/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.pathfinding;

import com.minecolonies.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.entity.pathfinding.AbstractPathJob;
import com.minecolonies.entity.pathfinding.Node;
import com.minecolonies.entity.pathfinding.PathResult;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class PathJobFindTree
extends AbstractPathJob {
    private BlockPos hutLocation;

    public PathJobFindTree(World world, BlockPos start, BlockPos home, int range) {
        super(world, start, start, range, new TreePathResult());
        this.hutLocation = home;
    }

    @Override
    public TreePathResult getResult() {
        return (TreePathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        int dx = pos.func_177958_n() - this.hutLocation.func_177958_n();
        int dy = pos.func_177956_o() - this.hutLocation.func_177956_o();
        int dz = pos.func_177952_p() - this.hutLocation.func_177952_p();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 0.951;
    }

    @Override
    protected boolean isAtDestination(Node n) {
        return n.parent != null && this.isNearTree(n);
    }

    private boolean isNearTree(Node n) {
        if (n.pos.func_177958_n() != n.parent.pos.func_177958_n()) {
            int dx = n.pos.func_177958_n() > n.parent.pos.func_177958_n() ? 1 : -1;
            return this.isTree(n.pos.func_177982_a(-dx, 0, 0)) || this.isTree(n.pos.func_177982_a(0, 0, -1)) || this.isTree(n.pos.func_177982_a(0, 0, 1));
        }
        int dz = n.pos.func_177952_p() > n.parent.pos.func_177952_p() ? 1 : -1;
        return this.isTree(n.pos.func_177982_a(0, 0, dz)) || this.isTree(n.pos.func_177982_a(-1, 0, 0)) || this.isTree(n.pos.func_177982_a(1, 0, 0));
    }

    private boolean isTree(BlockPos pos) {
        if (Tree.checkTree(this.world, pos)) {
            this.getResult().treeLocation = pos;
            return true;
        }
        return false;
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return 0.0;
    }

    @Override
    protected boolean isPassable(Block block, BlockPos pos) {
        return super.isPassable(block, pos) || block.isLeaves(this.world, pos);
    }

    public static class TreePathResult
    extends PathResult {
        public BlockPos treeLocation;
    }
}

