/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.items;

import com.minecolonies.blocks.ModBlocks;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.PlayerProperties;
import com.minecolonies.items.AbstractItemMinecolonies;
import com.minecolonies.items.ModItems;
import com.minecolonies.util.BlockUtils;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import com.minecolonies.util.SchematicWrapper;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemSupplyChestDeployer
extends AbstractItemMinecolonies {
    private static final int SPACE_RIGHT = 11;
    private static final int SPACE_LEFT = 20;
    private static final int LENGTH = 32;
    private static final int WIDTH = 20;
    private static final int DISTANCE = 4;

    public ItemSupplyChestDeployer() {
        this.func_77625_d(1);
    }

    @Override
    public String getName() {
        return "supplyChestDeployer";
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn == null || playerIn == null || worldIn.field_72995_K || stack.field_77994_a == 0 || !this.isFirstPlacing(playerIn)) {
            return false;
        }
        EnumFacing facing = this.canShipBePlaced(worldIn, pos);
        if (facing != EnumFacing.DOWN) {
            this.spawnShip(worldIn, pos, playerIn, facing);
            --stack.field_77994_a;
            return true;
        }
        LanguageHandler.sendPlayerLocalizedMessage(playerIn, "item.supplyChestDeployer.invalid", new Object[0]);
        return false;
    }

    public EnumFacing canShipBePlaced(World world, BlockPos pos) {
        if (this.check(world, pos.func_177976_e(), true, false)) {
            return EnumFacing.WEST;
        }
        if (this.check(world, pos.func_177974_f(), true, true)) {
            return EnumFacing.EAST;
        }
        if (this.check(world, pos.func_177968_d(), false, true)) {
            return EnumFacing.SOUTH;
        }
        if (this.check(world, pos.func_177978_c(), false, false)) {
            return EnumFacing.NORTH;
        }
        return EnumFacing.DOWN;
    }

    private boolean check(World world, BlockPos pos, boolean shouldCheckX, boolean isCoordPositivelyAdded) {
        int k = isCoordPositivelyAdded ? 1 : -1;
        int horizontalX = isCoordPositivelyAdded ? 20 : 11;
        int horizontalZ = isCoordPositivelyAdded ? 11 : 20;
        int spaceRightK = 11 * k;
        int spaceLeftK = 20 * k;
        int widthK = 20 * k;
        int widthKHalf = widthK / 2;
        if (shouldCheckX) {
            int i;
            for (i = 4; i < 20; ++i) {
                int j = k * i;
                if (BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(j, 0, 0))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(j, 0, spaceRightK))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(j, 0, -spaceLeftK)))) continue;
                return false;
            }
            for (i = 0; i < 32; ++i) {
                if (BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(4 * k, 0, -horizontalX + i))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(widthKHalf, 0, -horizontalX + i))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(widthK, 0, -horizontalX + i)))) continue;
                return false;
            }
        } else {
            int i;
            for (i = 4; i < 20; ++i) {
                int j = k * i;
                if (BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(0, 0, j))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(-spaceRightK, 0, j))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(spaceLeftK, 0, j)))) continue;
                return false;
            }
            for (i = 0; i < 32; ++i) {
                if (BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(-horizontalZ + i, 0, 4 * k))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(-horizontalZ + i, 0, widthKHalf))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(-horizontalZ + i, 0, widthK)))) continue;
                return false;
            }
        }
        return true;
    }

    boolean isFirstPlacing(EntityPlayer player) {
        if (Configurations.allowInfiniteSupplyChests || !PlayerProperties.get(player).getHasPlacedSupplyChest()) {
            return true;
        }
        LanguageHandler.sendPlayerLocalizedMessage(player, "com.minecolonies.error.supplyChestAlreadyPlaced", new Object[0]);
        return false;
    }

    private void spawnShip(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing chestFacing) {
        world.func_175656_a(pos.func_177984_a(), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)chestFacing));
        this.placeSupplyShip(world, pos, chestFacing);
        this.fillChest((TileEntityChest)world.func_175625_s(pos.func_177984_a()));
        PlayerProperties.get(entityPlayer).placeSupplyChest();
    }

    private void placeSupplyShip(World world, BlockPos pos, EnumFacing direction) {
        switch (direction) {
            case SOUTH: {
                SchematicWrapper.loadAndPlaceSchematicWithRotation(world, "supplyShip", pos.func_177982_a(-11, -2, 5), 3);
                break;
            }
            case NORTH: {
                SchematicWrapper.loadAndPlaceSchematicWithRotation(world, "supplyShip", pos.func_177982_a(-20, -2, -21), 1);
                break;
            }
            case EAST: {
                SchematicWrapper.loadAndPlaceSchematicWithRotation(world, "supplyShip", pos.func_177982_a(5, -2, -20), 2);
                break;
            }
            case WEST: {
                SchematicWrapper.loadAndPlaceSchematicWithRotation(world, "supplyShip", pos.func_177982_a(-21, -2, -11), 0);
                break;
            }
        }
    }

    private void fillChest(TileEntityChest chest) {
        if (chest == null) {
            Log.logger.error("Supply chest tile entity was null.");
            return;
        }
        chest.func_70299_a(0, new ItemStack(ModBlocks.blockHutTownHall));
        chest.func_70299_a(1, new ItemStack(ModItems.buildTool));
    }
}

