/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BuildRequestMessage
implements IMessage,
IMessageHandler<BuildRequestMessage, IMessage> {
    private BlockPos buildingId;
    private int colonyId;
    private int mode;
    public static final int BUILD = 0;
    public static final int REPAIR = 1;

    public BuildRequestMessage() {
    }

    public BuildRequestMessage(AbstractBuilding.View building, int mode) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.mode = mode;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.mode);
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.mode = buf.readInt();
    }

    public IMessage onMessage(BuildRequestMessage message, MessageContext ctx) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony == null) {
            return null;
        }
        AbstractBuilding building = colony.getBuilding(message.buildingId);
        if (building == null) {
            return null;
        }
        switch (message.mode) {
            case 0: {
                building.requestUpgrade();
                break;
            }
            case 1: {
                building.requestRepair();
                break;
            }
        }
        return null;
    }
}

