/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.Schematics;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.event.EventHandler;
import com.minecolonies.util.Log;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BuildToolPlaceMessage
implements IMessage,
IMessageHandler<BuildToolPlaceMessage, IMessage> {
    private String hutDec;
    private String style;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;

    public BuildToolPlaceMessage() {
    }

    public BuildToolPlaceMessage(String hutDec, String style, BlockPos pos, int rotation, boolean isHut) {
        this.hutDec = hutDec;
        this.style = style;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.hutDec);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.style);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
    }

    public void fromBytes(ByteBuf buf) {
        this.hutDec = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.style = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
    }

    public IMessage onMessage(BuildToolPlaceMessage message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.field_70170_p;
        if (message.isHut) {
            BuildToolPlaceMessage.handleHut(world, (EntityPlayer)player, message.hutDec, message.style, message.rotation, message.pos);
        } else {
            BuildToolPlaceMessage.handleDecoration(world, (EntityPlayer)player, message.hutDec, message.style, message.rotation, message.pos);
        }
        return null;
    }

    private static void handleHut(World world, EntityPlayer player, String hut, String style, int rotation, BlockPos buildPos) {
        if (Schematics.getStylesForHut(hut) == null) {
            Log.logger.error("No record of hut: " + hut);
            return;
        }
        Block block = Block.func_149684_b((String)("minecolonies:blockHut" + hut));
        if (player.field_71071_by.func_146028_b(Item.func_150898_a((Block)block)) && EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
            world.func_175655_b(buildPos, true);
            world.func_175656_a(buildPos, block.func_176223_P());
            block.func_180633_a(world, buildPos, world.func_180495_p(buildPos), (EntityLivingBase)player, null);
            player.field_71071_by.func_146026_a(Item.func_150898_a((Block)block));
            AbstractBuilding building = ColonyManager.getBuilding(world, buildPos);
            if (building != null) {
                building.setStyle(style);
                building.setRotation(rotation);
            } else {
                Log.logger.error("BuildTool: building is null!");
            }
        }
    }

    private static void handleDecoration(World world, EntityPlayer player, String decoration, String style, int rotation, BlockPos buildPos) {
        if (Schematics.getStylesForDecoration(decoration) == null) {
            Log.logger.error("No record of decoration: " + decoration);
            return;
        }
        Colony colony = ColonyManager.getColony(world, buildPos);
        if (colony != null && colony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
            colony.getWorkManager().addWorkOrder(new WorkOrderBuildDecoration(decoration, style, rotation, buildPos));
        }
    }
}

