/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.ColonyView;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ColonyViewMessage
implements IMessage,
IMessageHandler<ColonyViewMessage, IMessage> {
    private int colonyId;
    private boolean isNewSubscription;
    private ByteBuf colonyBuffer;

    public ColonyViewMessage() {
    }

    public ColonyViewMessage(Colony colony, boolean isNewSubscription) {
        this.colonyId = colony.getID();
        this.isNewSubscription = isNewSubscription;
        this.colonyBuffer = Unpooled.buffer();
        ColonyView.serializeNetworkData(colony, this.colonyBuffer, isNewSubscription);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.isNewSubscription);
        buf.writeBytes(this.colonyBuffer);
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.isNewSubscription = buf.readBoolean();
        this.colonyBuffer = buf;
    }

    public IMessage onMessage(ColonyViewMessage message, MessageContext ctx) {
        return ColonyManager.handleColonyViewMessage(message.colonyId, message.colonyBuffer, message.isNewSubscription);
    }
}

