/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.BuildingFarmer;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class FarmerCropTypeMessage
implements IMessage,
IMessageHandler<FarmerCropTypeMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int wheat;
    private int potato;
    private int carrot;
    private int melon;
    private int pumpkin;

    public FarmerCropTypeMessage() {
    }

    public FarmerCropTypeMessage(BuildingFarmer.View building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.wheat = building.wheat;
        this.potato = building.potato;
        this.carrot = building.carrot;
        this.melon = building.melon;
        this.pumpkin = building.pumpkin;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.wheat);
        buf.writeInt(this.potato);
        buf.writeInt(this.carrot);
        buf.writeInt(this.melon);
        buf.writeInt(this.pumpkin);
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.wheat = buf.readInt();
        this.potato = buf.readInt();
        this.carrot = buf.readInt();
        this.melon = buf.readInt();
        this.pumpkin = buf.readInt();
    }

    public IMessage onMessage(FarmerCropTypeMessage message, MessageContext ctx) {
        BuildingFarmer building;
        Colony colony;
        if (this.validatePacket() && (colony = ColonyManager.getColony(message.colonyId)) != null && (building = colony.getBuilding(message.buildingId, BuildingFarmer.class)) != null) {
            building.wheat = this.wheat;
            building.potato = this.potato;
            building.carrot = this.carrot;
            building.melon = this.melon;
            building.pumpkin = this.pumpkin;
        }
        return null;
    }

    private boolean validatePacket() {
        return this.wheat + this.potato + this.carrot + this.melon + this.pumpkin == 100;
    }
}

