/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RecallCitizenMessage
implements IMessage,
IMessageHandler<RecallCitizenMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;

    public RecallCitizenMessage() {
    }

    public RecallCitizenMessage(AbstractBuildingWorker.View building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
    }

    public IMessage onMessage(RecallCitizenMessage message, MessageContext ctx) {
        AbstractBuildingWorker building;
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null && (building = colony.getBuilding(message.buildingId, AbstractBuildingWorker.class)) != null) {
            BlockPos loc = building.getLocation();
            EntityCitizen citizen = building.getWorkerEntity();
            if (citizen != null) {
                World world = colony.getWorld();
                BlockPos spawnPoint = Utils.scanForBlockNearPoint(world, loc, 1, 0, 1, 2, new Block[]{Blocks.field_150350_a, Blocks.field_150431_aC, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N});
                citizen.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, citizen.field_70177_z, citizen.field_70125_A);
            }
        }
        return null;
    }
}

