/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.MineColonies;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.ColonyView;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class TownHallRenameMessage
implements IMessage,
IMessageHandler<TownHallRenameMessage, IMessage> {
    private int colonyId;
    private String name;

    public TownHallRenameMessage() {
    }

    public TownHallRenameMessage(ColonyView colony, String name) {
        this.colonyId = colony.getID();
        this.name = name;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public IMessage onMessage(TownHallRenameMessage message, MessageContext ctx) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            colony.setName(message.name);
            MineColonies.getNetwork().sendToAll((IMessage)message);
        }
        return null;
    }
}

