/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.tileentities;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.permissions.Permissions;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;

public class TileEntityColonyBuilding
extends TileEntityChest {
    private int colonyId = 0;
    private Colony colony;
    private AbstractBuilding building;
    private static final String TAG_COLONY = "colony";

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.colonyId == 0) {
            throw new IllegalStateException(String.format("TileEntityColonyBuilding at %s:[%d,%d,%d] has no colonyId", this.field_145850_b.func_72912_H().func_76065_j(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
        }
    }

    private void updateColonyReferences() {
        if (this.colony == null) {
            if (this.colonyId != 0) {
                this.colony = ColonyManager.getColony(this.colonyId);
            } else {
                throw new IllegalStateException(String.format("TileEntityColonyBuilding at %s:[%d,%d,%d] has no colonyId", this.field_145850_b.func_72912_H().func_76065_j(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
            }
        }
        if (this.building == null && this.colony != null) {
            this.building = this.colony.getBuilding(this.getPosition());
            if (this.building != null) {
                this.building.setTileEntity(this);
            }
        }
    }

    public void onChunkUnload() {
        if (this.building != null) {
            this.building.setTileEntity(null);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (!compound.func_74764_b(TAG_COLONY)) {
            throw new IllegalStateException(String.format("TileEntityColonyBuilding at %s:[%d,%d,%d] missing COLONY tag.", this.field_145850_b.func_72912_H().func_76065_j(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
        }
        this.colonyId = compound.func_74762_e(TAG_COLONY);
        this.updateColonyReferences();
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.colonyId == 0) {
            throw new IllegalStateException(String.format("TileEntityColonyBuilding at %s:[%d,%d,%d] has no colonyId; %s colony reference.", this.field_145850_b.func_72912_H().func_76065_j(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.colony == null ? "NO" : "valid"));
        }
        compound.func_74768_a(TAG_COLONY, this.colonyId);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.func_70300_a(player) && this.hasAccessPermission(player);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.colonyId = compound.func_74762_e(TAG_COLONY);
    }

    public S35PacketUpdateTileEntity getDescriptionPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(TAG_COLONY, this.colonyId);
        return new S35PacketUpdateTileEntity(this.getPosition(), 0, compound);
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public Colony getColony() {
        if (this.colony == null) {
            this.updateColonyReferences();
        }
        return this.colony;
    }

    public void setColony(Colony c) {
        this.colony = c;
        this.colonyId = c.getID();
        this.func_70296_d();
    }

    public AbstractBuilding getBuilding() {
        if (this.building == null) {
            this.updateColonyReferences();
        }
        return this.building;
    }

    public void setBuilding(AbstractBuilding b) {
        this.building = b;
    }

    public AbstractBuilding.View getBuildingView() {
        ColonyView c = ColonyManager.getColonyView(this.colonyId);
        return c != null ? c.getBuilding(this.getPosition()) : null;
    }

    public boolean hasAccessPermission(EntityPlayer player) {
        return this.building == null || this.building.getColony().getPermissions().hasPermission(player, Permissions.Action.ACCESS_HUTS);
    }

    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    public ItemStack func_70301_a(int index) {
        ItemStack stack = super.func_70301_a(index);
        if (stack == null) {
            return null;
        }
        return stack.func_77946_l();
    }

    public ItemStack func_70298_a(int index, int quantity) {
        ItemStack removed = super.func_70298_a(index, quantity);
        this.removeStackFromMaterialStore(removed);
        return removed;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack removed = super.func_70304_b(index);
        this.removeStackFromMaterialStore(removed);
        return removed;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack previous = this.func_70301_a(index);
        this.removeStackFromMaterialStore(previous);
        super.func_70299_a(index, stack);
        this.addStackToMaterialStore(stack);
    }

    private void addStackToMaterialStore(ItemStack stack) {
        if (stack == null) {
            return;
        }
    }

    private void removeStackFromMaterialStore(ItemStack stack) {
        if (stack == null) {
            return;
        }
    }
}

