/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.util;

import com.minecolonies.blocks.AbstractBlockHut;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockStoneSlabNew;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;

public final class BlockUtils {
    private static List<BiPredicate<Block, IBlockState>> freeToPlaceBlocks = Arrays.asList((block, iBlockState) -> block.equals(Blocks.field_150350_a), (block, iBlockState) -> block.func_149688_o().func_76224_d(), (block, iBlockState) -> BlockUtils.isWater(block.func_176223_P()), (block, iBlockState) -> block.equals(Blocks.field_150362_t), (block, iBlockState) -> block.equals(Blocks.field_150361_u), (block, iBlockState) -> block.equals(Blocks.field_150398_cm), (block, iBlockState) -> block.equals(Blocks.field_150349_c), (block, iBlockState) -> block instanceof BlockDoor && iBlockState != null && (Boolean)iBlockState.func_177229_b((IProperty)PropertyBool.func_177716_a((String)"upper")) != false);

    private BlockUtils() {
    }

    public static boolean shouldNeverBeMessedWith(Block block) {
        return block instanceof AbstractBlockHut || Objects.equals(block, Blocks.field_150357_h);
    }

    public static boolean freeToPlace(Block block) {
        return BlockUtils.freeToPlace(block, null);
    }

    public static boolean freeToPlace(Block block, IBlockState metadata) {
        if (block == null) {
            return true;
        }
        for (BiPredicate<Block, IBlockState> predicate : freeToPlaceBlocks) {
            if (!predicate.test(block, metadata)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWater(IBlockState iBlockState) {
        return Objects.equals(iBlockState, Blocks.field_150355_j.func_176223_P()) || Objects.equals(iBlockState, Blocks.field_150358_i.func_176223_P());
    }

    public static Item getItemFromBlock(Block block) {
        Item item = null;
        if (block instanceof BlockBanner) {
            item = Items.field_179564_cE;
        } else if (block instanceof BlockBed) {
            item = Items.field_151104_aV;
        } else if (block instanceof BlockBrewingStand) {
            item = Items.field_151067_bt;
        } else if (block instanceof BlockCake) {
            item = Items.field_151105_aU;
        } else if (block instanceof BlockCauldron) {
            item = Items.field_151066_bu;
        } else if (block instanceof BlockCocoa) {
            item = Items.field_151100_aR;
        } else if (block instanceof BlockCrops) {
            item = block instanceof BlockCarrot ? Items.field_151172_bF : (block instanceof BlockPotato ? Items.field_151174_bG : Items.field_151014_N);
        } else if (block instanceof BlockDaylightDetector) {
            item = Item.func_150898_a((Block)Blocks.field_150453_bW);
        } else if (block instanceof BlockDoor) {
            item = block == Blocks.field_150454_av ? Items.field_151139_aw : (block == Blocks.field_180414_ap ? Items.field_179569_ar : (block == Blocks.field_180412_aq ? Items.field_179568_as : (block == Blocks.field_180411_ar ? Items.field_179567_at : (block == Blocks.field_180410_as ? Items.field_179572_au : (block == Blocks.field_180409_at ? Items.field_179571_av : Items.field_179570_aq)))));
        } else if (block instanceof BlockFarmland) {
            item = Item.func_150898_a((Block)Blocks.field_150346_d);
        } else if (block instanceof BlockFlowerPot) {
            item = Items.field_151162_bE;
        } else if (block instanceof BlockFurnace) {
            item = Item.func_150898_a((Block)Blocks.field_150460_al);
        } else if (block instanceof BlockNetherWart) {
            item = Items.field_151075_bm;
        } else if (block instanceof BlockRedstoneComparator) {
            item = Items.field_151132_bS;
        } else if (block instanceof BlockRedstoneLight) {
            item = Item.func_150898_a((Block)Blocks.field_150379_bu);
        } else if (block instanceof BlockRedstoneRepeater) {
            item = Items.field_151107_aW;
        } else if (block instanceof BlockRedstoneTorch) {
            item = Item.func_150898_a((Block)Blocks.field_150429_aA);
        } else if (block instanceof BlockRedstoneWire) {
            item = Items.field_151137_ax;
        } else if (block instanceof BlockReed) {
            item = Items.field_151120_aE;
        } else if (block instanceof BlockSign) {
            item = Items.field_151155_ap;
        } else if (block instanceof BlockSkull) {
            item = Items.field_151144_bL;
        } else if (block instanceof BlockStem) {
            item = block == Blocks.field_150423_aK ? Items.field_151080_bb : (block == Blocks.field_150440_ba ? Items.field_151081_bc : null);
        } else if (block instanceof BlockStoneSlab) {
            item = Item.func_150898_a((Block)Blocks.field_150333_U);
        } else if (block instanceof BlockStoneSlabNew) {
            item = Item.func_150898_a((Block)Blocks.field_180389_cP);
        } else if (block instanceof BlockTripWire) {
            item = Items.field_151007_F;
        } else if (block instanceof BlockWoodSlab) {
            item = Item.func_150898_a((Block)Blocks.field_150376_bx);
        }
        return item;
    }
}

