/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.util;

import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public final class EntityUtils {
    private static final int DEFAULT_MOVE_RANGE = 3;
    private static final int AIR_SPACE_ABOVE_TO_CHECK = 2;

    private EntityUtils() {
    }

    public static boolean isWorkerAtSiteWithMove(EntityCitizen worker, int x, int y, int z) {
        return EntityUtils.isWorkerAtSiteWithMove(worker, x, y, z, 3);
    }

    public static boolean isWorkerAtSiteWithMove(EntityCitizen worker, int x, int y, int z, int range) {
        if (!EntityUtils.isWorkerAtSite(worker, x, y, z, range)) {
            if (worker.getNavigator().func_75500_f() && !EntityUtils.tryMoveLivingToXYZ((EntityLiving)worker, x, y, z)) {
                worker.setStatus(EntityCitizen.Status.PATHFINDING_ERROR);
            }
            return false;
        }
        return true;
    }

    public static boolean isWorkerAtSite(EntityCitizen worker, int x, int y, int z, int range) {
        return worker.func_180425_c().func_177951_i(new Vec3i(x, y, z)) < MathUtils.square(range);
    }

    public static boolean tryMoveLivingToXYZ(EntityLiving living, int x, int y, int z) {
        return EntityUtils.tryMoveLivingToXYZ(living, x, y, z, 1.0);
    }

    public static boolean tryMoveLivingToXYZ(EntityLiving living, int x, int y, int z, double speed) {
        return living.func_70661_as().func_75492_a((double)x, (double)y, (double)z, speed);
    }

    public static EntityPlayer getPlayerFromUUID(World world, UUID id) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            if (!id.equals(((EntityPlayer)world.field_73010_i.get(i)).func_146103_bH().getId())) continue;
            return (EntityPlayer)world.field_73010_i.get(i);
        }
        return null;
    }

    public static Entity getEntityFromUUID(World world, UUID id) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            if (!id.equals(((Entity)world.field_72996_f.get(i)).func_110124_au())) continue;
            return (Entity)world.field_72996_f.get(i);
        }
        return null;
    }

    public static List<EntityPlayer> getPlayersFromUUID(World world, Collection<UUID> ids) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (Object o : world.field_73010_i) {
            EntityPlayer player;
            if (!(o instanceof EntityPlayer) || !ids.contains((player = (EntityPlayer)o).func_146103_bH().getId())) continue;
            players.add(player);
            if (players.size() != ids.size()) continue;
            return players;
        }
        return players;
    }

    public static List<Entity> getEntitiesFromUUID(World world, Collection<UUID> ids) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object o : world.field_72996_f) {
            Entity entity;
            if (!(o instanceof Entity) || !ids.contains((entity = (Entity)o).func_110124_au())) continue;
            entities.add(entity);
            if (entities.size() != ids.size()) continue;
            return entities;
        }
        return entities;
    }

    public static List<Entity> getEntitiesFromID(World world, List<Integer> ids) {
        return ids.stream().map(arg_0 -> ((World)world).func_73045_a(arg_0)).collect(Collectors.toList());
    }

    public static boolean isPathingTo(EntityCitizen citizen, int x, int z) {
        PathPoint pathpoint = citizen.getNavigator().func_75505_d().func_75870_c();
        return pathpoint != null && pathpoint.field_75839_a == x && pathpoint.field_75838_c == z;
    }

    public static boolean checkForFreeSpace(World world, BlockPos groundPosition) {
        for (int i = 1; i < 2; ++i) {
            if (!EntityUtils.solidOrLiquid(world, groundPosition.func_177981_b(i))) continue;
            return false;
        }
        return world.func_180495_p(groundPosition).func_177230_c().func_149688_o().func_76220_a();
    }

    public static boolean solidOrLiquid(World world, BlockPos blockPos) {
        Material material = world.func_180495_p(blockPos).func_177230_c().func_149688_o();
        return material.func_76220_a() || material.func_76224_d();
    }
}

