/*
 * Decompiled with CFR 0.152.
 */
package com.schematica.client.renderer.chunk.overlay;

import com.schematica.client.renderer.chunk.CompiledOverlay;
import com.schematica.client.world.SchematicWorld;
import com.schematica.core.client.renderer.GeometryTessellator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RegionRenderCache;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RenderOverlay
extends RenderChunk {
    private final VertexBuffer vertexBuffer = OpenGlHelper.func_176075_f() ? new VertexBuffer(DefaultVertexFormats.field_181706_f) : null;

    public RenderOverlay(World world, RenderGlobal renderGlobal, BlockPos pos, int index) {
        super(world, renderGlobal, pos, index);
    }

    public VertexBuffer func_178565_b(int layer) {
        return this.vertexBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_178581_b(float x, float y, float z, ChunkCompileTaskGenerator generator) {
        RegionRenderCache regionRenderCache;
        CompiledOverlay compiledOverlay = new CompiledOverlay();
        BlockPos from = this.func_178568_j();
        BlockPos to = from.func_177982_a(15, 15, 15);
        generator.func_178540_f().lock();
        SchematicWorld schematic = (SchematicWorld)this.field_178588_d;
        try {
            if (generator.func_178546_a() != ChunkCompileTaskGenerator.Status.COMPILING) {
                return;
            }
            if (from.func_177958_n() < 0 || from.func_177952_p() < 0 || from.func_177958_n() >= schematic.getWidth() || from.func_177952_p() >= schematic.getLength()) {
                generator.func_178543_a(CompiledChunk.field_178502_a);
                return;
            }
            regionRenderCache = new RegionRenderCache(this.field_178588_d, from.func_177982_a(-1, -1, -1), to.func_177982_a(1, 1, 1), 1);
            generator.func_178543_a((CompiledChunk)compiledOverlay);
        }
        finally {
            generator.func_178540_f().unlock();
        }
        VisGraph visgraph = new VisGraph();
        if (!regionRenderCache.func_72806_N()) {
            RenderOverlay.increamentRenderChunkedUpdated();
            WorldClient mcWorld = Minecraft.func_71410_x().field_71441_e;
            EnumWorldBlockLayer layer = EnumWorldBlockLayer.TRANSLUCENT;
            WorldRenderer worldRenderer = generator.func_178545_d().func_179038_a(layer);
            GeometryTessellator.setStaticDelta(0.005);
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)from, (BlockPos)to)) {
                if (schematic.isRenderingLayer && schematic.renderingLayer != pos.func_177956_o() || !schematic.isInside(pos)) continue;
                boolean render = false;
                int sides = 0;
                int color = 0;
                IBlockState schBlockState = schematic.func_180495_p(pos);
                Block schBlock = schBlockState.func_177230_c();
                if (schBlock.func_149662_c()) {
                    visgraph.func_178606_a(pos);
                }
                BlockPos mcPos = pos.func_177971_a((Vec3i)schematic.position);
                IBlockState mcBlockState = mcWorld.func_180495_p(mcPos);
                Block mcBlock = mcBlockState.func_177230_c();
                boolean isSchAirBlock = schematic.func_175623_d(pos);
                boolean isMcAirBlock = mcWorld.func_175623_d(mcPos);
                if (!isMcAirBlock && isSchAirBlock) {
                    render = true;
                    color = 0xBF00BF;
                    sides = RenderOverlay.getSides(mcBlock, (World)mcWorld, mcPos, sides);
                }
                if (!render) {
                    if (!isMcAirBlock) {
                        if (schBlock != mcBlock) {
                            render = true;
                            color = 0xFF0000;
                        } else if (schBlock.func_176201_c(schBlockState) != mcBlock.func_176201_c(mcBlockState)) {
                            render = true;
                            color = 12541696;
                        }
                    } else if (!isSchAirBlock) {
                        render = true;
                        color = 49151;
                    }
                    if (render) {
                        sides = RenderOverlay.getSides(schBlock, (World)schematic, pos, sides);
                    }
                }
                if (!render || sides == 0) continue;
                if (!compiledOverlay.func_178492_d(layer)) {
                    compiledOverlay.func_178493_c(layer);
                    this.func_178573_a(worldRenderer, from);
                }
                GeometryTessellator.drawCuboid(worldRenderer, pos, sides, 0x3F000000 | color);
                compiledOverlay.func_178486_a(layer);
            }
            if (compiledOverlay.func_178492_d(layer)) {
                this.func_178584_a(layer, x, y, z, worldRenderer, compiledOverlay);
            }
        }
        compiledOverlay.func_178488_a(visgraph.func_178607_a());
    }

    private static void increamentRenderChunkedUpdated() {
        ++field_178592_a;
    }

    private static int getSides(Block block, World world, BlockPos pos, int s) {
        int sides = s;
        if (block.func_176225_a((IBlockAccess)world, pos.func_177972_a(EnumFacing.DOWN), EnumFacing.DOWN)) {
            sides |= 1;
        }
        if (block.func_176225_a((IBlockAccess)world, pos.func_177972_a(EnumFacing.UP), EnumFacing.UP)) {
            sides |= 2;
        }
        if (block.func_176225_a((IBlockAccess)world, pos.func_177972_a(EnumFacing.NORTH), EnumFacing.NORTH)) {
            sides |= 4;
        }
        if (block.func_176225_a((IBlockAccess)world, pos.func_177972_a(EnumFacing.SOUTH), EnumFacing.SOUTH)) {
            sides |= 8;
        }
        if (block.func_176225_a((IBlockAccess)world, pos.func_177972_a(EnumFacing.WEST), EnumFacing.WEST)) {
            sides |= 0x10;
        }
        if (block.func_176225_a((IBlockAccess)world, pos.func_177972_a(EnumFacing.EAST), EnumFacing.EAST)) {
            sides |= 0x20;
        }
        return sides;
    }

    public void func_178573_a(WorldRenderer worldRenderer, BlockPos pos) {
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
    }

    public void func_178566_a() {
        super.func_178566_a();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.func_177362_c();
        }
    }
}

