/*
 * Decompiled with CFR 0.152.
 */
package com.schematica.world.schematic;

import com.schematica.nbt.NBTHelper;
import com.schematica.reference.Reference;
import com.schematica.world.schematic.SchematicFormat;
import com.schematica.world.schematic.SchematicUtil;
import com.schematica.world.storage.Schematic;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;

class SchematicAlpha
extends SchematicFormat {
    private static final String OFFSET_X = "OffsetX";
    private static final String OFFSET_Y = "OffsetY";
    private static final String OFFSET_Z = "OffsetZ";
    private static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();

    SchematicAlpha() {
    }

    @Override
    public Schematic readFromNBT(NBTTagCompound tagCompound) {
        ItemStack icon = SchematicUtil.getIconFromNBT(tagCompound);
        byte[] localBlocks = tagCompound.func_74770_j("Blocks");
        byte[] localMetadata = tagCompound.func_74770_j("Data");
        boolean extra = false;
        byte[] extraBlocks = null;
        if (tagCompound.func_74764_b("AddBlocks")) {
            extra = true;
            byte[] extraBlocksNibble = tagCompound.func_74770_j("AddBlocks");
            extraBlocks = new byte[extraBlocksNibble.length * 2];
            for (int i = 0; i < extraBlocksNibble.length; ++i) {
                extraBlocks[i * 2] = (byte)(extraBlocksNibble[i] >> 4 & 0xF);
                extraBlocks[i * 2 + 1] = (byte)(extraBlocksNibble[i] & 0xF);
            }
        } else if (tagCompound.func_74764_b("Add")) {
            extra = true;
            extraBlocks = tagCompound.func_74770_j("Add");
        }
        int width = tagCompound.func_74765_d("Width");
        int length = tagCompound.func_74765_d("Length");
        int height = tagCompound.func_74765_d("Height");
        HashMap<Short, Short> oldToNew = new HashMap<Short, Short>();
        if (tagCompound.func_74764_b("SchematicaMapping")) {
            NBTTagCompound mapping = tagCompound.func_74775_l("SchematicaMapping");
            Set names = mapping.func_150296_c();
            for (String name : names) {
                oldToNew.put(mapping.func_74765_d(name), (short)BLOCK_REGISTRY.getId(new ResourceLocation(name)));
            }
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Schematic schematic = new Schematic(icon, width, height, length);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = x + (y * length + z) * width;
                    int blockID = localBlocks[index] & 0xFF | (extra ? (extraBlocks[index] & 0xFF) << 8 : 0);
                    int meta = localMetadata[index] & 0xFF;
                    Short id = (Short)oldToNew.get((short)blockID);
                    if (id != null) {
                        blockID = id.shortValue();
                    }
                    Block block = (Block)BLOCK_REGISTRY.func_148754_a(blockID);
                    pos.func_181079_c(x, y, z);
                    try {
                        IBlockState blockState = block.func_176203_a(meta);
                        schematic.setBlockState((BlockPos)pos, blockState);
                        continue;
                    }
                    catch (RuntimeException e) {
                        Reference.logger.error("Could not set block state at {} to {} with metadata {}", new Object[]{pos, BLOCK_REGISTRY.getNameForObject((Object)block), meta, e});
                    }
                }
            }
        }
        NBTTagList tileEntitiesList = tagCompound.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tileEntitiesList.func_74745_c(); ++i) {
            try {
                TileEntity tileEntity = NBTHelper.readTileEntityFromCompound(tileEntitiesList.func_150305_b(i));
                if (tileEntity == null) continue;
                schematic.setTileEntity(tileEntity.func_174877_v(), tileEntity);
                continue;
            }
            catch (RuntimeException e) {
                Reference.logger.error("TileEntity failed to load properly!", (Throwable)e);
            }
        }
        if (tagCompound.func_74764_b(OFFSET_X)) {
            short xOffset = tagCompound.func_74765_d(OFFSET_X);
            short yOffset = tagCompound.func_74765_d(OFFSET_Y);
            short zOffset = tagCompound.func_74765_d(OFFSET_Z);
            schematic.setOffset(new BlockPos((int)xOffset, (int)yOffset, (int)zOffset));
        }
        return schematic;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound, Schematic schematic) {
        NBTTagCompound tagCompoundIcon = new NBTTagCompound();
        ItemStack icon = schematic.getIcon();
        icon.func_77955_b(tagCompoundIcon);
        tagCompound.func_74782_a("Icon", (NBTBase)tagCompoundIcon);
        tagCompound.func_74777_a("Width", (short)schematic.getWidth());
        tagCompound.func_74777_a("Length", (short)schematic.getLength());
        tagCompound.func_74777_a("Height", (short)schematic.getHeight());
        int size = schematic.getWidth() * schematic.getLength() * schematic.getHeight();
        byte[] localBlocks = new byte[size];
        byte[] localMetadata = new byte[size];
        byte[] extraBlocks = new byte[size];
        byte[] extraBlocksNibble = new byte[(int)Math.ceil((double)size / 2.0)];
        boolean extra = false;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        HashMap<String, Short> mappings = new HashMap<String, Short>();
        for (int x = 0; x < schematic.getWidth(); ++x) {
            for (int y = 0; y < schematic.getHeight(); ++y) {
                for (int z = 0; z < schematic.getLength(); ++z) {
                    String name;
                    int index = x + (y * schematic.getLength() + z) * schematic.getWidth();
                    IBlockState blockState = schematic.getBlockState((BlockPos)pos.func_181079_c(x, y, z));
                    Block block = blockState.func_177230_c();
                    int blockId = BLOCK_REGISTRY.getId((Object)block);
                    localBlocks[index] = (byte)blockId;
                    localMetadata[index] = (byte)block.func_176201_c(blockState);
                    extraBlocks[index] = (byte)(blockId >> 8);
                    if (extraBlocks[index] > 0) {
                        extra = true;
                    }
                    if (mappings.containsKey(name = String.valueOf(BLOCK_REGISTRY.getNameForObject((Object)block)))) continue;
                    mappings.put(name, (short)blockId);
                }
            }
        }
        int count = 20;
        NBTTagList tileEntitiesList = new NBTTagList();
        for (TileEntity tileEntity : schematic.getTileEntities()) {
            try {
                NBTTagCompound tileEntityTagCompound = NBTHelper.writeTileEntityToCompound(tileEntity);
                tileEntitiesList.func_74742_a((NBTBase)tileEntityTagCompound);
            }
            catch (RuntimeException e) {
                BlockPos tePos = tileEntity.func_174877_v();
                int index = tePos.func_177958_n() + (tePos.func_177956_o() * schematic.getLength() + tePos.func_177952_p()) * schematic.getWidth();
                if (--count > 0) {
                    IBlockState blockState = schematic.getBlockState(tePos);
                    Block block = blockState.func_177230_c();
                    Reference.logger.error("Block {}[{}] with TileEntity {} failed to save! Replacing with bedrock...", new Object[]{block, block != null ? BLOCK_REGISTRY.getNameForObject((Object)block) : "?", tileEntity.getClass().getName(), e});
                }
                localBlocks[index] = (byte)BLOCK_REGISTRY.getId((Object)Blocks.field_150357_h);
                localMetadata[index] = 0;
                extraBlocks[index] = 0;
            }
        }
        for (int i = 0; i < extraBlocksNibble.length; ++i) {
            extraBlocksNibble[i] = i * 2 + 1 < extraBlocks.length ? (byte)(extraBlocks[i * 2] << 4 | extraBlocks[i * 2 + 1] & 0xFF) : (byte)(extraBlocks[i * 2] << 4);
        }
        NBTTagList entityList = new NBTTagList();
        List<Entity> entities = schematic.getEntities();
        for (Entity entity : entities) {
            try {
                NBTTagCompound entityCompound = NBTHelper.writeEntityToCompound(entity);
                if (entityCompound == null) continue;
                entityList.func_74742_a((NBTBase)entityCompound);
            }
            catch (ReportedException e) {
                Reference.logger.error("Entity {} failed to save, skipping!", new Object[]{entity, e});
            }
        }
        NBTTagCompound nbtMapping = new NBTTagCompound();
        for (Map.Entry entry : mappings.entrySet()) {
            nbtMapping.func_74777_a((String)entry.getKey(), ((Short)entry.getValue()).shortValue());
        }
        tagCompound.func_74778_a("Materials", "Alpha");
        tagCompound.func_74773_a("Blocks", localBlocks);
        tagCompound.func_74773_a("Data", localMetadata);
        if (extra) {
            tagCompound.func_74773_a("AddBlocks", extraBlocksNibble);
        }
        tagCompound.func_74782_a("Entities", (NBTBase)entityList);
        tagCompound.func_74782_a("TileEntities", (NBTBase)tileEntitiesList);
        tagCompound.func_74782_a("SchematicaMapping", (NBTBase)nbtMapping);
        tagCompound.func_74777_a(OFFSET_X, (short)schematic.getOffset().func_177958_n());
        tagCompound.func_74777_a(OFFSET_Y, (short)schematic.getOffset().func_177956_o());
        tagCompound.func_74777_a(OFFSET_Z, (short)schematic.getOffset().func_177952_p());
    }
}

