/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.client.gui;

import com.blockout.Alignment;
import com.blockout.View;
import com.blockout.controls.Button;
import com.blockout.controls.Image;
import com.blockout.controls.Label;
import com.blockout.views.Window;
import com.minecolonies.MineColonies;
import com.minecolonies.colony.CitizenDataView;
import com.minecolonies.network.messages.OpenInventoryMessage;
import com.minecolonies.util.ExperienceUtils;
import com.minecolonies.util.LanguageHandler;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WindowCitizen
extends Window
implements Button.Handler {
    private static final String INVENTORY_BUTTON_ID = "inventory";
    private static final String CITIZEN_RESOURCE_SUFFIX = ":gui/windowCitizen.xml";
    private static final String STRENGTH = "strength";
    private static final String ENDURANCE = "endurance";
    private static final String CHARISMA = "charisma";
    private static final String INTELLIGENCE = "intelligence";
    private static final String DEXTERITY = "dexterity";
    private static final int XP_HEIGHT = 5;
    private static final int LEFT_BORDER_X = 10;
    private static final int LEFT_BORDER_Y = 10;
    private static final int XP_BAR_ICON_COLUMN = 0;
    private static final int XP_BAR_ICON_COLUMN_END = 172;
    private static final int XP_BAR_ICON_COLUMN_END_WIDTH = 10;
    private static final int XP_BAR_ICON_END_OFFSET = 90;
    private static final int XP_BAR_WIDTH = 91;
    private static final int XP_BAR_EMPTY_ROW = 64;
    private static final int XP_BAR_FULL_ROW = 69;
    private static final int XP_LABEL_X = -20;
    private static final int XP_LABEL_Y = 28;
    private static final int EMPTY_HEART_ICON_ROW_POS = 16;
    private static final int FULL_HEART_ICON_ROW_POS = 53;
    private static final int HALF_HEART_ICON_ROW_POS = 62;
    private static final int HEART_ICON_COLUMN = 0;
    private static final int HEART_ICON_HEIGHT_WIDTH = 9;
    private static final int HEART_ICON_POS_X = 10;
    private static final int HEART_ICON_OFFSET_X = 10;
    private static final int HEART_ICON_POS_Y = 10;
    private static final String WINDOW_ID_NAME = "name";
    private static final String WINDOW_ID_XP = "xpLabel";
    private static final String WINDOW_ID_XPBAR = "xpBar";
    private static final String WINDOW_ID_HEALTHBAR = "healthBar";
    private CitizenDataView citizen;

    public WindowCitizen(CitizenDataView citizen) {
        super("minecolonies:gui/windowCitizen.xml");
        this.citizen = citizen;
    }

    private void createXpBar() {
        double experienceRatio = ExperienceUtils.getPercentOfLevelCompleted(this.citizen.getExperience(), this.citizen.getLevel());
        this.findPaneOfTypeByID(WINDOW_ID_XP, Label.class).setLabelText(Integer.toString(this.citizen.getLevel()));
        this.findPaneOfTypeByID(WINDOW_ID_XP, Label.class).setPosition(-20, 28);
        Image xpBar = new Image();
        xpBar.setImage(Gui.field_110324_m, 0, 64, 91, 5);
        xpBar.setPosition(10, 10);
        Image xpBar2 = new Image();
        xpBar2.setImage(Gui.field_110324_m, 172, 64, 10, 5);
        xpBar2.setPosition(100, 10);
        this.findPaneOfTypeByID(WINDOW_ID_XPBAR, View.class).addChild(xpBar);
        this.findPaneOfTypeByID(WINDOW_ID_XPBAR, View.class).addChild(xpBar2);
        if (experienceRatio > 0.0) {
            Image xpBarFull = new Image();
            xpBarFull.setImage(Gui.field_110324_m, 0, 69, (int)experienceRatio, 5);
            xpBarFull.setPosition(10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_XPBAR, View.class).addChild(xpBarFull);
        }
    }

    private void createHealthBar() {
        int heartPos;
        Image heart;
        this.findPaneOfTypeByID(WINDOW_ID_HEALTHBAR, View.class).setAlignment(Alignment.MiddleRight);
        int i = 0;
        while ((double)i < this.citizen.getMaxHealth() / 2.0) {
            heart = new Image();
            heart.setImage(Gui.field_110324_m, 16, 0, 9, 9);
            heart.setPosition(i * 10 + 10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_HEALTHBAR, View.class).addChild(heart);
            ++i;
        }
        for (heartPos = 0; heartPos < (int)this.citizen.getHealth() / 2; ++heartPos) {
            heart = new Image();
            heart.setImage(Gui.field_110324_m, 53, 0, 9, 9);
            heart.setPosition(heartPos * 10 + 10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_HEALTHBAR, View.class).addChild(heart);
        }
        if (this.citizen.getHealth() / 2.0 % 1.0 > 0.0) {
            heart = new Image();
            heart.setImage(Gui.field_110324_m, 62, 0, 9, 9);
            heart.setPosition(heartPos * 10 + 10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_HEALTHBAR, View.class).addChild(heart);
        }
    }

    @Override
    public void onOpened() {
        this.findPaneOfTypeByID(WINDOW_ID_NAME, Label.class).setLabelText(this.citizen.getName());
        this.createHealthBar();
        this.createXpBar();
        this.createSkillContent();
    }

    private void createSkillContent() {
        this.findPaneOfTypeByID(STRENGTH, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.gui.citizen.skills.strength", this.citizen.getStrength()));
        this.findPaneOfTypeByID(ENDURANCE, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.gui.citizen.skills.endurance", this.citizen.getEndurance()));
        this.findPaneOfTypeByID(CHARISMA, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.gui.citizen.skills.charisma", this.citizen.getCharisma()));
        this.findPaneOfTypeByID(INTELLIGENCE, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.gui.citizen.skills.intelligence", this.citizen.getIntelligence()));
        this.findPaneOfTypeByID(DEXTERITY, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.gui.citizen.skills.dexterity", this.citizen.getDexterity()));
    }

    @Override
    public void onButtonClicked(Button button) {
        if (button.getID().equals(INVENTORY_BUTTON_ID)) {
            MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(this.citizen));
        }
    }
}

