/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.achievements.ModAchievements;
import com.minecolonies.client.gui.WindowHutFisherman;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.colony.jobs.JobFisherman;
import com.minecolonies.util.ServerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;

public class BuildingFisherman
extends AbstractBuildingWorker {
    private static final int MAX_BUILDING_LEVEL = 3;
    private static final String FISHERMAN = "Fisherman";

    public BuildingFisherman(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public String getSchematicName() {
        return FISHERMAN;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 3;
    }

    @Override
    public String getJobName() {
        return FISHERMAN;
    }

    @Override
    public AbstractJob createJob(CitizenData citizen) {
        return new JobFisherman(citizen);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        EntityPlayer owner = ServerUtils.getPlayerFromUUID(this.getColony().getPermissions().getOwner());
        if (newLevel == 1) {
            owner.func_71029_a((StatBase)ModAchievements.achievementBuildingFisher);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            owner.func_71029_a((StatBase)ModAchievements.achievementUpgradeFisherMax);
        }
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public Window getWindow() {
            return new WindowHutFisherman(this);
        }
    }
}

