/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.achievements.ModAchievements;
import com.minecolonies.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.colony.jobs.JobLumberjack;
import com.minecolonies.util.ServerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;

public class BuildingLumberjack
extends AbstractBuildingWorker {
    private static final int MAX_BUILDING_LEVEL = 3;
    private static final String LUMBERJACK = "Lumberjack";
    private static final String LUMBERJACK_HUT_NAME = "lumberjackHut";

    public BuildingLumberjack(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public String getSchematicName() {
        return LUMBERJACK;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 3;
    }

    @Override
    public String getJobName() {
        return LUMBERJACK;
    }

    @Override
    public AbstractJob createJob(CitizenData citizen) {
        return new JobLumberjack(citizen);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        EntityPlayer owner = ServerUtils.getPlayerFromUUID(this.getColony().getPermissions().getOwner());
        if (newLevel == 1) {
            owner.func_71029_a((StatBase)ModAchievements.achievementBuildingLumberjack);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            owner.func_71029_a((StatBase)ModAchievements.achievementUpgradeLumberjackMax);
        }
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingLumberjack.LUMBERJACK_HUT_NAME);
        }
    }
}

