/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.workorders;

import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.WorkOrderView;
import com.minecolonies.colony.workorders.WorkOrderBuild;
import com.minecolonies.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.util.Log;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class AbstractWorkOrder {
    protected int id;
    private int claimedBy;
    private int priority;
    private static Map<String, Class<? extends AbstractWorkOrder>> nameToClassMap = new HashMap<String, Class<? extends AbstractWorkOrder>>();
    private static Map<Class<? extends AbstractWorkOrder>, String> classToNameMap = new HashMap<Class<? extends AbstractWorkOrder>, String>();
    private static final String TAG_TYPE = "type";
    private static final String TAG_ID = "id";
    private static final String TAG_CLAIMED_BY = "claimedBy";
    private boolean changed = false;

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void resetChange() {
        this.changed = false;
    }

    protected abstract WorkOrderType getType();

    protected abstract String getValue();

    private static void addMapping(String name, Class<? extends AbstractWorkOrder> orderClass) {
        if (nameToClassMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding Work Order class mapping");
        }
        try {
            if (orderClass.getDeclaredConstructor(new Class[0]) != null) {
                nameToClassMap.put(name, orderClass);
                classToNameMap.put(orderClass, name);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding Work Order class mapping", exception);
        }
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public boolean isClaimed() {
        return this.claimedBy != 0;
    }

    public boolean isClaimedBy(CitizenData citizen) {
        return citizen.getId() == this.claimedBy;
    }

    public int getClaimedBy() {
        return this.claimedBy;
    }

    void setClaimedBy(CitizenData citizen) {
        this.changed = true;
        this.claimedBy = citizen != null ? citizen.getId() : 0;
    }

    public void clearClaimedBy() {
        this.changed = true;
        this.claimedBy = 0;
    }

    public static AbstractWorkOrder createFromNBT(NBTTagCompound compound) {
        AbstractWorkOrder order = null;
        Class<? extends AbstractWorkOrder> oclass = null;
        try {
            oclass = nameToClassMap.get(compound.func_74779_i(TAG_TYPE));
            if (oclass != null) {
                Constructor<? extends AbstractWorkOrder> constructor = oclass.getDeclaredConstructor(new Class[0]);
                order = constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.logger.trace((Object)e);
        }
        if (order == null) {
            Log.logger.warn(String.format("Unknown WorkOrder type '%s' or missing constructor of proper format.", compound.func_74779_i(TAG_TYPE)));
            return null;
        }
        try {
            order.readFromNBT(compound);
        }
        catch (RuntimeException ex) {
            Log.logger.error(String.format("A WorkOrder %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.func_74779_i(TAG_TYPE), oclass.getName()), (Throwable)ex);
            return null;
        }
        return order;
    }

    public void writeToNBT(NBTTagCompound compound) {
        String s = classToNameMap.get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.func_74778_a(TAG_TYPE, s);
        compound.func_74768_a(TAG_ID, this.id);
        if (this.claimedBy != 0) {
            compound.func_74768_a(TAG_CLAIMED_BY, this.claimedBy);
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.id = compound.func_74762_e(TAG_ID);
        this.claimedBy = compound.func_74762_e(TAG_CLAIMED_BY);
    }

    public boolean isValid(Colony colony) {
        return true;
    }

    public abstract void attemptToFulfill(Colony var1);

    public void serializeViewNetworkData(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.priority);
        buf.writeInt(this.claimedBy);
        buf.writeInt(this.getType().ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getValue());
    }

    public static WorkOrderView createWorkOrderView(ByteBuf buf) {
        WorkOrderView workOrderView = new WorkOrderView();
        try {
            workOrderView.deserialize(buf);
        }
        catch (RuntimeException ex) {
            Log.logger.error(String.format("A WorkOrder.View for #%d has thrown an exception during loading, its state cannot be restored. Report this to the mod author", workOrderView.getId()), (Throwable)ex);
            workOrderView = null;
        }
        return workOrderView;
    }

    static {
        AbstractWorkOrder.addMapping("build", WorkOrderBuild.class);
        AbstractWorkOrder.addMapping("decoration", WorkOrderBuildDecoration.class);
    }

    public static enum WorkOrderType {
        BUILD;

    }
}

