/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity;

import com.minecolonies.proxy.CommonProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public final class PlayerProperties
implements IExtendedEntityProperties {
    private boolean hasPlacedSupplyChest = false;

    private PlayerProperties() {
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties("minecolonies.PlayerProperties", (IExtendedEntityProperties)new PlayerProperties());
    }

    public static PlayerProperties get(EntityPlayer player) {
        return (PlayerProperties)player.getExtendedProperties("minecolonies.PlayerProperties");
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74757_a("hasPlacedSupplyChest", this.hasPlacedSupplyChest);
        compound.func_74782_a("minecolonies.PlayerProperties", (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a("minecolonies.PlayerProperties");
        this.hasPlacedSupplyChest = properties.func_74767_n("hasPlacedSupplyChest");
    }

    public void init(Entity entity, World world) {
    }

    private static String getSaveKey(EntityPlayer player) {
        return player.func_146103_bH().getId().toString() + ":" + "minecolonies.PlayerProperties";
    }

    public static void saveProxyData(EntityPlayer player) {
        PlayerProperties playerData = PlayerProperties.get(player);
        NBTTagCompound savedData = new NBTTagCompound();
        playerData.saveNBTData(savedData);
        CommonProxy.storeEntityData(PlayerProperties.getSaveKey(player), savedData);
    }

    public static void loadProxyData(EntityPlayer player) {
        PlayerProperties playerData = PlayerProperties.get(player);
        NBTTagCompound savedData = CommonProxy.getEntityData(PlayerProperties.getSaveKey(player));
        if (savedData != null) {
            playerData.loadNBTData(savedData);
        }
    }

    public boolean hasPlacedSupplyChest() {
        return this.hasPlacedSupplyChest;
    }

    public void placeSupplyChest() {
        this.hasPlacedSupplyChest = true;
    }
}

