/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.basic;

import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.entity.ai.util.AITarget;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.BlockUtils;
import com.minecolonies.util.InventoryUtils;
import com.minecolonies.util.Log;
import com.minecolonies.util.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIInteract<J extends AbstractJob>
extends AbstractEntityAICrafting<J> {
    private static final int DELAY_MODIFIER = 100;
    private static final double XP_PER_BLOCK = 0.05;
    private static final double LEVEL_MODIFIER = 0.95;

    public AbstractEntityAIInteract(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget[0]);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine) {
        return this.mineBlock(blockToMine, new BlockPos((int)this.worker.field_70165_t, (int)this.worker.field_70163_u, (int)this.worker.field_70161_v));
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        Block curBlock = this.world.func_180495_p(blockToMine).func_177230_c();
        if (curBlock == null || curBlock.equals(Blocks.field_150350_a) || BlockUtils.shouldNeverBeMessedWith(curBlock)) {
            return true;
        }
        if (this.checkMiningLocation(blockToMine, safeStand)) {
            return false;
        }
        ItemStack tool = this.worker.func_70694_bm();
        int fortune = Utils.getFortuneOf(tool);
        List<ItemStack> items = BlockPosUtil.getBlockDrops(this.world, blockToMine, fortune);
        this.worker.breakBlockWithToolInHand(blockToMine);
        for (ItemStack item : items) {
            InventoryUtils.setStack(this.worker.getInventoryCitizen(), item);
        }
        this.worker.addExperience(0.05);
        this.incrementActionsDone();
        return true;
    }

    private boolean checkMiningLocation(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        Block curBlock = this.world.func_180495_p(blockToMine).func_177230_c();
        if (!this.holdEfficientTool(curBlock)) {
            return true;
        }
        ItemStack tool = this.worker.func_70694_bm();
        if (tool != null && !ForgeHooks.canToolHarvestBlock((IBlockAccess)this.world, (BlockPos)blockToMine, (ItemStack)tool) && curBlock != Blocks.field_150357_h) {
            Log.logger.info(String.format("ForgeHook not in sync with EfficientTool for %s and %s\nPlease report to MineColonies with this text to add support!", curBlock, tool));
        }
        if (this.walkToBlock(safeStand)) {
            return true;
        }
        this.currentWorkingLocation = blockToMine;
        this.currentStandingLocation = safeStand;
        return this.hasNotDelayed(this.getBlockMiningDelay(curBlock, blockToMine));
    }

    private int getBlockMiningDelay(@NotNull Block block, @NotNull BlockPos pos) {
        if (this.worker.func_70694_bm() == null) {
            return (int)block.func_176195_g(this.world, pos);
        }
        return (int)(100.0 * Math.pow(0.95, this.worker.getLevel()) * (double)block.func_176195_g(this.world, pos) / (double)this.worker.func_70694_bm().func_77973_b().getDigSpeed(this.worker.func_70694_bm(), block.func_176223_P()));
    }
}

