/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.citizen.builder;

import com.minecolonies.blocks.AbstractBlockHut;
import com.minecolonies.blocks.ModBlocks;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.jobs.JobBuilder;
import com.minecolonies.colony.workorders.WorkOrderBuild;
import com.minecolonies.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.entity.ai.util.AIState;
import com.minecolonies.entity.ai.util.AITarget;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.BlockUtils;
import com.minecolonies.util.EntityUtils;
import com.minecolonies.util.InventoryUtils;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import com.minecolonies.util.MathUtils;
import com.minecolonies.util.SchematicWrapper;
import com.minecolonies.util.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructure<JobBuilder> {
    private static final double XP_EACH_BUILDING = 2.5;
    private static final int INTELLIGENCE_MULTIPLIER = 2;
    private static final int STRENGTH_MULTIPLIER = 1;
    private static final int MAX_ADDITIONAL_RANGE_TO_BUILD = 25;
    private static final int STANDARD_WORKING_RANGE = 5;
    private static final int MIN_WORKING_RANGE = 7;
    private static final int ACTIONS_UNTIL_DUMP = 1024;
    private BlockPos workFrom = null;

    public EntityAIStructureBuilder(JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget(this::checkIfCanceled, AIState.IDLE), new AITarget(this::checkIfExecute, this::getState), new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.BUILDER_CLEAR_STEP, this::clearStep), new AITarget(AIState.BUILDER_REQUEST_MATERIALS, this::requestMaterials), new AITarget(AIState.BUILDER_STRUCTURE_STEP, this::structureStep), new AITarget(AIState.BUILDER_DECORATION_STEP, this::decorationStep), new AITarget(AIState.BUILDER_COMPLETE_BUILD, this::completeBuild));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getIntelligence() + 1 * this.worker.getCitizenData().getStrength());
        this.worker.func_98053_h(true);
    }

    private boolean checkIfCanceled() {
        WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            this.cancelTask();
            return true;
        }
        return false;
    }

    private boolean checkIfExecute() {
        this.setDelay(1);
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            return true;
        }
        WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
        if (((JobBuilder)this.job).getColony().getBuilding(wo.getBuildingLocation()) == null && !(wo instanceof WorkOrderBuildDecoration)) {
            ((JobBuilder)this.job).complete();
            return true;
        }
        if (!((JobBuilder)this.job).hasSchematic()) {
            this.initiate();
        }
        return false;
    }

    private AIState initiate() {
        if (!((JobBuilder)this.job).hasSchematic()) {
            this.workFrom = null;
            this.loadSchematic();
            WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
            if (wo == null) {
                Log.logger.error(String.format("Builder (%d:%d) ERROR - Starting and missing work order(%d)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), ((JobBuilder)this.job).getWorkOrderId()));
                return this.getState();
            }
            if (wo instanceof WorkOrderBuildDecoration) {
                LanguageHandler.sendPlayersLocalizedMessage(this.worker.getColony().getMessageEntityPlayers(), "entity.builder.messageBuildStart", ((JobBuilder)this.job).getSchematic().getName());
                if (!((JobBuilder)this.job).hasSchematic() || !((JobBuilder)this.job).getSchematic().decrementBlock()) {
                    return this.getState();
                }
                return AIState.START_WORKING;
            }
            AbstractBuilding building = ((JobBuilder)this.job).getColony().getBuilding(wo.getBuildingLocation());
            if (building == null) {
                Log.logger.error(String.format("Builder (%d:%d) ERROR - Starting and missing building(%s)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                return this.getState();
            }
            LanguageHandler.sendPlayersLocalizedMessage(this.worker.getColony().getMessageEntityPlayers(), "entity.builder.messageBuildStart", ((JobBuilder)this.job).getSchematic().getName());
            if (building.getBuildingLevel() > 0) {
                wo.setCleared(true);
                if (!((JobBuilder)this.job).hasSchematic() || !this.incrementBlock()) {
                    return this.getState();
                }
                return AIState.BUILDER_REQUEST_MATERIALS;
            }
            if (!((JobBuilder)this.job).hasSchematic() || !((JobBuilder)this.job).getSchematic().decrementBlock()) {
                return this.getState();
            }
            return AIState.START_WORKING;
        }
        BlockPosUtil.tryMoveLivingToXYZ((EntityLiving)this.worker, ((JobBuilder)this.job).getSchematic().getPosition());
        return AIState.IDLE;
    }

    private boolean incrementBlock() {
        return ((JobBuilder)this.job).getSchematic().incrementBlock();
    }

    private void loadSchematic() {
        WorkOrderBuild workOrder = ((JobBuilder)this.job).getWorkOrder();
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getBuildingLocation();
        if (!(workOrder instanceof WorkOrderBuildDecoration) && this.worker.getColony().getBuilding(pos) == null) {
            Log.logger.warn("AbstractBuilding does not exist - removing build request");
            this.worker.getColony().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        try {
            ((JobBuilder)this.job).setSchematic(new SchematicWrapper(this.world, workOrder.getSchematicName()));
        }
        catch (IllegalStateException e) {
            Log.logger.warn(String.format("Schematic: (%s) does not exist - removing build request", workOrder.getSchematicName()), (Throwable)e);
            ((JobBuilder)this.job).setSchematic(null);
            return;
        }
        ((JobBuilder)this.job).getSchematic().rotate(workOrder.getRotation());
        ((JobBuilder)this.job).getSchematic().setPosition(pos);
        workOrder.setCleared(false);
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.BUILDER_CLEAR_STEP;
    }

    private boolean goToConstructionSite() {
        if (this.workFrom == null) {
            this.workFrom = this.getWorkingPosition();
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 5) || MathUtils.twoDimDistance(this.worker.func_180425_c(), this.workFrom) < 7.0;
    }

    private BlockPos getWorkingPosition() {
        return this.getWorkingPosition(0);
    }

    private BlockPos getWorkingPosition(int offset) {
        EnumFacing[] directions;
        if (offset > 25) {
            return ((JobBuilder)this.job).getSchematic().getBlockPosition();
        }
        int length = ((JobBuilder)this.job).getSchematic().getLength();
        int width = ((JobBuilder)this.job).getSchematic().getWidth();
        int distance = width > length ? width : length;
        for (EnumFacing direction : directions = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}) {
            BlockPos positionInDirection = this.getPositionInDirection(direction, distance);
            if (!EntityUtils.checkForFreeSpace(this.world, positionInDirection)) continue;
            return positionInDirection;
        }
        return this.getWorkingPosition(offset + 1);
    }

    private BlockPos getPositionInDirection(EnumFacing facing, int distance) {
        return this.getFloor(((JobBuilder)this.job).getSchematic().getPosition().func_177967_a(facing, distance));
    }

    private BlockPos getFloor(BlockPos position) {
        if (!EntityUtils.solidOrLiquid(this.world, position)) {
            return this.getFloor(position.func_177977_b());
        }
        if (!EntityUtils.solidOrLiquid(this.world, position.func_177984_a())) {
            return position;
        }
        return this.getFloor(position.func_177984_a());
    }

    private AIState clearStep() {
        WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo.isCleared()) {
            return AIState.BUILDER_STRUCTURE_STEP;
        }
        BlockPos coordinates = ((JobBuilder)this.job).getSchematic().getBlockPosition();
        Block worldBlock = this.world.func_180495_p(coordinates).func_177230_c();
        if (worldBlock != Blocks.field_150350_a && !(worldBlock instanceof AbstractBlockHut) && worldBlock != Blocks.field_150357_h && ((JobBuilder)this.job).getSchematic().getBlock() != ModBlocks.blockSubstitution) {
            if (!this.goToConstructionSite()) {
                return this.getState();
            }
            this.worker.faceBlock(coordinates);
            if (Configurations.builderInfiniteResources || worldBlock.func_149688_o().func_76224_d()) {
                this.worker.func_70062_b(0, null);
                if (!this.world.func_175698_g(coordinates)) {
                    Log.logger.error(String.format("Block break failure at %d, %d, %d", coordinates.func_177958_n(), coordinates.func_177956_o(), coordinates.func_177952_p()));
                }
                this.worker.func_71038_i();
            } else if (!this.mineBlock(coordinates)) {
                return this.getState();
            }
        }
        if (!((JobBuilder)this.job).getSchematic().findNextBlockToClear()) {
            ((JobBuilder)this.job).getSchematic().reset();
            this.incrementBlock();
            wo.setCleared(true);
            return AIState.BUILDER_REQUEST_MATERIALS;
        }
        return this.getState();
    }

    private AIState requestMaterials() {
        if (!Configurations.builderInfiniteResources) {
            while (((JobBuilder)this.job).getSchematic().findNextBlock()) {
                if (((JobBuilder)this.job).getSchematic().doesSchematicBlockEqualWorldBlock()) continue;
                Block block = ((JobBuilder)this.job).getSchematic().getBlock();
                ItemStack itemstack = new ItemStack(block, 1);
                Block worldBlock = BlockPosUtil.getBlock(this.world, ((JobBuilder)this.job).getSchematic().getBlockPosition());
                if (itemstack.func_77973_b() == null || block == null || block == Blocks.field_150350_a || worldBlock == Blocks.field_150357_h || worldBlock instanceof AbstractBlockHut || this.isBlockFree(block, 0) || !this.checkOrRequestItems(new ItemStack(block))) continue;
                ((JobBuilder)this.job).getSchematic().reset();
                return this.getState();
            }
            ((JobBuilder)this.job).getSchematic().reset();
            this.incrementBlock();
        }
        return AIState.BUILDER_STRUCTURE_STEP;
    }

    private boolean isBlockFree(Block block, int metadata) {
        return block == null || BlockUtils.isWater(block.func_176223_P()) || block.equals(Blocks.field_150362_t) || block.equals(Blocks.field_150361_u) || block.equals(Blocks.field_150398_cm) && Utils.testFlag(metadata, 8) || block instanceof BlockDoor && Utils.testFlag(metadata, 8) || block.equals(Blocks.field_150349_c) || block.equals(Blocks.field_150346_d);
    }

    private AIState structureStep() {
        if (!this.goToConstructionSite()) {
            return this.getState();
        }
        if (((JobBuilder)this.job).getSchematic().getBlock() == null || ((JobBuilder)this.job).getSchematic().doesSchematicBlockEqualWorldBlock() || !((JobBuilder)this.job).getSchematic().getBlock().func_149688_o().func_76220_a() && ((JobBuilder)this.job).getSchematic().getBlock() != Blocks.field_150350_a) {
            return this.findNextBlockSolid();
        }
        this.worker.faceBlock(((JobBuilder)this.job).getSchematic().getBlockPosition());
        Block block = ((JobBuilder)this.job).getSchematic().getBlock();
        IBlockState blockState = ((JobBuilder)this.job).getSchematic().getBlockState();
        BlockPos coordinates = ((JobBuilder)this.job).getSchematic().getBlockPosition();
        Block worldBlock = this.world.func_180495_p(coordinates).func_177230_c();
        if (block == null) {
            BlockPos local = ((JobBuilder)this.job).getSchematic().getLocalPosition();
            Log.logger.error(String.format("Schematic has null block at %s - local(%s)", coordinates, local));
            this.findNextBlockSolid();
            return this.getState();
        }
        if (worldBlock instanceof AbstractBlockHut || worldBlock == Blocks.field_150357_h || block instanceof AbstractBlockHut) {
            return this.findNextBlockSolid();
        }
        if (!Configurations.builderInfiniteResources && !this.handleMaterials(block, blockState)) {
            return this.getState();
        }
        this.placeBlockAt(block, blockState, coordinates);
        return this.findNextBlockSolid();
    }

    private AIState decorationStep() {
        if (!this.goToConstructionSite()) {
            return this.getState();
        }
        if (((JobBuilder)this.job).getSchematic().doesSchematicBlockEqualWorldBlock() || ((JobBuilder)this.job).getSchematic().getBlock().func_149688_o().func_76220_a()) {
            return this.findNextBlockNonSolid();
        }
        this.worker.faceBlock(((JobBuilder)this.job).getSchematic().getBlockPosition());
        Block block = ((JobBuilder)this.job).getSchematic().getBlock();
        IBlockState blockState = ((JobBuilder)this.job).getSchematic().getBlockState();
        BlockPos coords = ((JobBuilder)this.job).getSchematic().getBlockPosition();
        Block worldBlock = this.world.func_180495_p(coords).func_177230_c();
        if (block == null) {
            BlockPos local = ((JobBuilder)this.job).getSchematic().getLocalPosition();
            Log.logger.error(String.format("Schematic has null block at %s- local(%s)", coords, local));
            this.findNextBlockNonSolid();
            return this.getState();
        }
        if (worldBlock instanceof AbstractBlockHut || worldBlock == Blocks.field_150357_h || block instanceof AbstractBlockHut) {
            this.findNextBlockNonSolid();
            return this.getState();
        }
        if (!Configurations.builderInfiniteResources && !this.handleMaterials(block, blockState)) {
            return this.getState();
        }
        this.placeBlockAt(block, blockState, coords);
        return this.findNextBlockNonSolid();
    }

    private void placeBlockAt(Block block, IBlockState blockState, BlockPos coords) {
        if (block == Blocks.field_150350_a) {
            this.worker.func_70062_b(0, null);
            if (!this.world.func_175698_g(coords)) {
                Log.logger.error(String.format("Block break failure at %s", coords));
            }
        } else {
            Item item = Item.func_150898_a((Block)block);
            this.worker.func_70062_b(0, item != null ? new ItemStack(item, 1) : null);
            if (this.placeBlock(coords, block, blockState)) {
                this.setTileEntity(coords);
            } else {
                Log.logger.error(String.format("Block place failure %s at %s", block.func_149739_a(), coords));
            }
            this.worker.func_71038_i();
        }
    }

    private void spawnEntity(Entity entity) {
        if (entity != null) {
            BlockPos pos = ((JobBuilder)this.job).getSchematic().getOffsetPosition();
            if (entity instanceof EntityHanging) {
                EntityHanging entityHanging = (EntityHanging)entity;
                entityHanging.field_70165_t += (double)pos.func_177958_n();
                entityHanging.field_70163_u += (double)pos.func_177956_o();
                entityHanging.field_70161_v += (double)pos.func_177952_p();
                entityHanging.func_70107_b((double)entityHanging.func_174857_n().func_177958_n(), (double)entityHanging.func_174857_n().func_177956_o(), (double)entityHanging.func_174857_n().func_177952_p());
                entityHanging.func_70029_a(this.world);
                entityHanging.field_71093_bK = this.world.field_73011_w.func_177502_q();
                this.world.func_72838_d((Entity)entityHanging);
            } else if (entity instanceof EntityMinecart) {
                EntityMinecart minecart = (EntityMinecart)entity;
                minecart.field_70153_n = null;
                minecart.field_70165_t += (double)pos.func_177958_n();
                minecart.field_70163_u += (double)pos.func_177956_o();
                minecart.field_70161_v += (double)pos.func_177952_p();
                minecart.func_70029_a(this.world);
                minecart.field_71093_bK = this.world.field_73011_w.func_177502_q();
                this.world.func_72838_d((Entity)minecart);
            }
        }
    }

    private boolean handleMaterials(Block block, IBlockState blockState) {
        if (block == Blocks.field_150350_a) {
            return true;
        }
        if (this.isBlockFree(block, block.func_176201_c(blockState))) {
            return true;
        }
        return !this.checkOrRequestItems(BlockUtils.getItemStackFromBlockState(blockState));
    }

    private boolean placeBlock(BlockPos pos, Block block, IBlockState blockState) {
        if (MathHelper.func_76128_c((double)this.worker.field_70165_t) == pos.func_177958_n() && MathHelper.func_76130_a((int)(pos.func_177956_o() - (int)this.worker.field_70163_u)) <= 1 && MathHelper.func_76128_c((double)this.worker.field_70161_v) == pos.func_177952_p() && this.worker.getNavigator().func_75500_f()) {
            this.worker.getNavigator().moveAwayFromXYZ(pos, 4.1, 1.0);
        }
        if (blockState.func_177230_c() instanceof BlockStairs && this.world.func_180495_p(pos).func_177230_c() instanceof BlockStairs && this.world.func_180495_p(pos).func_177229_b((IProperty)BlockStairs.field_176309_a) == blockState.func_177229_b((IProperty)BlockStairs.field_176309_a) && blockState.func_177230_c() == this.world.func_180495_p(pos).func_177230_c()) {
            return true;
        }
        if (!Configurations.builderInfiniteResources && this.world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) {
            List<ItemStack> items = BlockPosUtil.getBlockDrops(this.world, pos, 0);
            for (ItemStack item : items) {
                InventoryUtils.setStack(this.worker.getInventoryCitizen(), item);
            }
        }
        if (block instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.LOWER)) {
            ItemDoor.func_179235_a((World)this.world, (BlockPos)pos, (EnumFacing)((EnumFacing)blockState.func_177229_b((IProperty)BlockDoor.field_176520_a)), (Block)block);
        } else if (block instanceof BlockBed) {
            this.world.func_180501_a(pos, blockState, 3);
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockBed.field_176387_N);
            if (blockState.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
                this.world.func_180501_a(pos.func_177972_a(facing), blockState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD), 3);
            } else {
                this.world.func_180501_a(pos.func_177972_a(facing), blockState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT), 3);
            }
        } else if (block instanceof BlockDoublePlant) {
            this.world.func_180501_a(pos, blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.LOWER), 3);
            this.world.func_180501_a(pos.func_177984_a(), blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER), 3);
        } else {
            if (block instanceof BlockEndPortal || block instanceof BlockMobSpawner || block instanceof BlockDragonEgg || block instanceof BlockPortal) {
                return true;
            }
            if (!this.world.func_180501_a(pos, blockState, 3)) {
                return false;
            }
            if (this.world.func_180495_p(pos).func_177230_c() == block && this.world.func_180495_p(pos) != blockState) {
                this.world.func_180501_a(pos, blockState, 3);
            }
        }
        ItemStack stack = BlockUtils.getItemStackFromBlockState(blockState);
        if (stack == null) {
            Log.logger.error("Block causes NPE: " + blockState.func_177230_c());
            return false;
        }
        int slot = this.worker.findFirstSlotInInventoryWith(stack.func_77973_b());
        if (slot != -1) {
            this.getInventory().func_70298_a(slot, 1);
        }
        return true;
    }

    private void setTileEntity(BlockPos pos) {
        TileEntity tileEntity = ((JobBuilder)this.job).getSchematic().getTileEntity();
        if (tileEntity != null && this.world.func_175625_s(pos) != null) {
            this.world.func_175690_a(pos, tileEntity);
        }
    }

    private AIState findNextBlockSolid() {
        if (!((JobBuilder)this.job).getSchematic().findNextBlockSolid()) {
            ((JobBuilder)this.job).getSchematic().reset();
            this.incrementBlock();
            return AIState.BUILDER_DECORATION_STEP;
        }
        return this.getState();
    }

    private AIState findNextBlockNonSolid() {
        if (!((JobBuilder)this.job).getSchematic().findNextBlockNonSolid()) {
            ((JobBuilder)this.job).getSchematic().reset();
            this.incrementBlock();
            return AIState.BUILDER_COMPLETE_BUILD;
        }
        return this.getState();
    }

    private AIState completeBuild() {
        ((JobBuilder)this.job).getSchematic().getEntities().forEach(this::spawnEntity);
        String schematicName = ((JobBuilder)this.job).getSchematic().getName();
        LanguageHandler.sendPlayersLocalizedMessage(this.worker.getColony().getMessageEntityPlayers(), "entity.builder.messageBuildComplete", schematicName);
        WorkOrderBuild wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo != null) {
            if (!(wo instanceof WorkOrderBuildDecoration)) {
                AbstractBuilding building = ((JobBuilder)this.job).getColony().getBuilding(wo.getBuildingLocation());
                if (building != null) {
                    building.setBuildingLevel(wo.getUpgradeLevel());
                } else {
                    Log.logger.error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                }
            }
            ((JobBuilder)this.job).complete();
        } else {
            Log.logger.error(String.format("Builder (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getColony().getID(), this.worker.getCitizenData().getId(), ((JobBuilder)this.job).getWorkOrderId()));
        }
        this.func_75251_c();
        this.worker.addExperience(2.5);
        this.workFrom = null;
        return AIState.IDLE;
    }

    public void cancelTask() {
        super.func_75251_c();
        ((JobBuilder)this.job).setWorkOrder(null);
        this.workFrom = null;
        ((JobBuilder)this.job).setSchematic(null);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1024;
    }

    @Override
    protected boolean neededForWorker(@Nullable ItemStack stack) {
        return Utils.isMiningTool(stack);
    }
}

