/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.citizen.farmer;

import com.minecolonies.colony.buildings.BuildingFarmer;
import com.minecolonies.colony.jobs.JobFarmer;
import com.minecolonies.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityAIWorkFarmer
extends AbstractEntityAIInteract<JobFarmer> {
    private static final String TOOL_TYPE_HOE = "hoe";
    private static final String TOOL_TYPE_SHOVEL = "shovel";
    private static final String RENDER_META_SEEDS = "Seeds";
    private static final Logger logger = LogManager.getLogger((String)"Farmer");
    private List<BlockPos> farmAbleLand = new ArrayList<BlockPos>();
    private List<BlockPos> plowedLand = new ArrayList<BlockPos>();
    private List<BlockPos> crops = new ArrayList<BlockPos>();
    private List<BlockPos> crops2 = new ArrayList<BlockPos>();
    private BlockPos currentFarmLand;
    private int harvestCounter = 0;
    private String needItem = "";
    private int delay = 0;

    public EntityAIWorkFarmer(JobFarmer job) {
        super(job);
    }

    @Override
    protected BuildingFarmer getOwnBuilding() {
        return (BuildingFarmer)this.worker.getWorkBuilding();
    }

    private void checkForCrops() {
        if (this.crops.isEmpty() && !this.crops2.isEmpty()) {
            this.crops.addAll(this.crops2);
            this.crops2.clear();
            ((JobFarmer)this.job).setStage(Stage.NEED_SEEDS);
        }
    }

    @Override
    protected void updateRenderMetaData() {
        String renderMetaData = this.getRenderMetaSeeds();
        this.worker.setRenderMetadata(renderMetaData);
    }

    private String getRenderMetaSeeds() {
        if (this.hasSeed()) {
            return RENDER_META_SEEDS;
        }
        return "";
    }

    private boolean hasSeed() {
        for (int slot = 0; slot < this.getInventory().func_70302_i_(); ++slot) {
            Item content;
            ItemStack stack = this.getInventory().func_70301_a(slot);
            if (stack == null || stack.func_77973_b() == null || !EntityAIWorkFarmer.isSeed(content = stack.func_77973_b())) continue;
            return true;
        }
        ((JobFarmer)this.job).setStage(Stage.NEED_SEEDS);
        return false;
    }

    private static boolean isSeed(Item item) {
        return item.toString().contains("Seed") || item.toString().contains("potatoe") || item.toString().contains("carrot");
    }

    private boolean waitingForSomething() {
        if (this.delay > 0) {
            if (((JobFarmer)this.job).getStage() == Stage.MAKING_LAND) {
                this.worker.hitBlockWithToolInHand(this.currentFarmLand);
            }
            --this.delay;
            return true;
        }
        return false;
    }

    private boolean itemsAreMissing() {
        if (((JobFarmer)this.job).isMissingNeededItem()) {
            if (BlockPosUtil.isWorkerAtSiteWithMove(this.worker, this.worker.getWorkBuilding().getLocation())) {
                CopyOnWriteArrayList<ItemStack> l = new CopyOnWriteArrayList<ItemStack>();
                l.addAll(((JobFarmer)this.job).getItemsNeeded());
                for (ItemStack e : l) {
                    if (this.isInHut(e.func_77973_b()) || this.hasAllTheTools() || this.inventoryContains(e.func_77973_b()) != -1) {
                        ((JobFarmer)this.job).removeItemNeeded(e);
                        return true;
                    }
                    this.worker.sendLocalizedChat("entity.miner.messageNeedBlockAndItem", e.func_82833_r());
                }
                this.delay = 50;
            }
            return true;
        }
        return false;
    }

    private boolean isInHut(Item item) {
        if (this.worker.getWorkBuilding().getTileEntity() == null) {
            return false;
        }
        int size = this.worker.getWorkBuilding().getTileEntity().func_70302_i_();
        for (int i = 0; i < size; ++i) {
            Item content;
            ItemStack stack = this.worker.getWorkBuilding().getTileEntity().func_70301_a(i);
            if (stack == null || !(content = stack.func_77973_b()).equals(item) && !content.getToolClasses(stack).contains(this.needItem) && !stack.func_77977_a().contains(this.needItem)) continue;
            ItemStack returnStack = InventoryUtils.setStack(this.getInventory(), stack);
            if (returnStack == null) {
                this.worker.getWorkBuilding().getTileEntity().func_70298_a(i, stack.field_77994_a);
            } else {
                this.worker.getWorkBuilding().getTileEntity().func_70298_a(i, stack.field_77994_a - returnStack.field_77994_a);
            }
            return true;
        }
        return false;
    }

    private boolean hasAllTheTools() {
        boolean hoe;
        boolean hasSpadeInHand;
        boolean hasHoeInHand;
        if (this.worker.func_70694_bm() == null) {
            hasHoeInHand = false;
            hasSpadeInHand = false;
        } else {
            hasHoeInHand = this.worker.func_70694_bm().func_77977_a().contains(TOOL_TYPE_HOE);
            hasSpadeInHand = this.worker.func_70694_bm().func_77973_b().getToolClasses(this.worker.func_70694_bm()).contains(TOOL_TYPE_SHOVEL);
        }
        int hasSpade = InventoryUtils.getFirstSlotContainingTool(this.getInventory(), TOOL_TYPE_SHOVEL);
        int hasHoe = InventoryUtils.getFirstSlotContainingTool(this.getInventory(), TOOL_TYPE_HOE);
        boolean spade = hasSpade > -1 || hasSpadeInHand;
        boolean bl = hoe = hasHoeInHand || hasHoe > -1;
        if (!spade) {
            ((JobFarmer)this.job).addItemNeededIfNotAlready(new ItemStack(Items.field_151037_a));
            this.needItem = TOOL_TYPE_SHOVEL;
        } else if (!hoe) {
            ((JobFarmer)this.job).addItemNeededIfNotAlready(new ItemStack(Items.field_151019_K));
            this.needItem = TOOL_TYPE_HOE;
        }
        return hoe && spade;
    }

    private int inventoryContains(Item item) {
        if (item == null) {
            return -1;
        }
        for (int slot = 0; slot < this.getInventory().func_70302_i_(); ++slot) {
            Item content;
            ItemStack stack = this.getInventory().func_70301_a(slot);
            if (stack == null || stack.func_77973_b() == null || !(content = stack.func_77973_b()).equals(item)) continue;
            return slot;
        }
        return -1;
    }

    private void startWorking() {
        switch (((JobFarmer)this.job).getStage()) {
            case FULL_INVENTORY: {
                this.dumpInventory();
                break;
            }
            case SEARCHING_LAND: {
                this.searchFarmableLand();
                break;
            }
            case MAKING_LAND: {
                this.makeLand();
                break;
            }
            case NEED_SEEDS: {
                this.needSeeds();
                break;
            }
            case WORKING: {
                this.doWork();
                break;
            }
            case PLANTING: {
                this.planting();
                break;
            }
            case HARVESTING: {
                this.harvesting();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid state for Farmer.");
            }
        }
    }

    private void doWork() {
        if (this.farmAbleLand.isEmpty() && this.plowedLand.isEmpty() && this.crops.isEmpty()) {
            ((JobFarmer)this.job).setStage(Stage.SEARCHING_LAND);
        } else if (!this.hasSeed() && this.crops.size() + this.crops2.size() < 10) {
            ((JobFarmer)this.job).setStage(Stage.NEED_SEEDS);
        } else if (!this.farmAbleLand.isEmpty()) {
            ((JobFarmer)this.job).setStage(Stage.MAKING_LAND);
        } else if (this.hasSeed() && !this.plowedLand.isEmpty()) {
            ((JobFarmer)this.job).setStage(Stage.PLANTING);
        } else if (!this.crops.isEmpty()) {
            ((JobFarmer)this.job).setStage(Stage.HARVESTING);
        }
    }

    private void needSeeds() {
        if (BlockPosUtil.isWorkerAtSiteWithMove(this.worker, this.worker.getWorkBuilding().getLocation())) {
            this.delay = 200;
            logger.info("Need Seeds");
            if (this.hasSeed() || this.hasSeedInHut()) {
                ((JobFarmer)this.job).setStage(Stage.PLANTING);
            }
        }
    }

    private void searchFarmableLand() {
        BuildingFarmer b = (BuildingFarmer)this.worker.getWorkBuilding();
        if (b == null) {
            return;
        }
        int buildingX = this.worker.getWorkBuilding().getLocation().func_177958_n();
        int buildingY = this.worker.getWorkBuilding().getLocation().func_177956_o();
        int buildingZ = this.worker.getWorkBuilding().getLocation().func_177952_p();
        for (int x = buildingX - b.getFarmRadius() - 1; x <= buildingX + b.getFarmRadius() + 1; ++x) {
            for (int z = buildingZ - b.getFarmRadius() - 1; z <= buildingZ + b.getFarmRadius() + 1; ++z) {
                Block block = this.world.func_180495_p(new BlockPos(x, buildingY - 1, z)).func_177230_c();
                if (block == Blocks.field_150346_d || block == Blocks.field_150349_c) {
                    if (!this.world.func_175623_d(new BlockPos(x, buildingY + 1, z)) || !this.farmAbleLand.isEmpty() && this.farmAbleLand.contains(new BlockPos(x, buildingY, z))) continue;
                    this.farmAbleLand.add(new BlockPos(x, buildingY, z));
                    continue;
                }
                if (block != Blocks.field_150458_ak) continue;
                Block blockAbove = this.world.func_180495_p(new BlockPos(x, buildingY, z)).func_177230_c();
                if (blockAbove == Blocks.field_150464_aj || blockAbove == Blocks.field_150469_bN || blockAbove == Blocks.field_150459_bM || blockAbove == Blocks.field_150394_bc || blockAbove == Blocks.field_150440_ba || blockAbove == Blocks.field_150423_aK || blockAbove == Blocks.field_150393_bb) {
                    if (!this.crops.isEmpty() && this.crops.contains(new BlockPos(x, buildingY, z))) continue;
                    this.crops.add(new BlockPos(x, buildingY, z));
                    continue;
                }
                if (!this.plowedLand.isEmpty() && this.plowedLand.contains(new BlockPos(x, buildingY, z))) continue;
                this.plowedLand.add(new BlockPos(x, buildingY, z));
            }
        }
        ((JobFarmer)this.job).setStage(Stage.WORKING);
    }

    private void makeLand() {
        if (!this.farmAbleLand.isEmpty()) {
            if (this.world.func_180495_p(new BlockPos(this.farmAbleLand.get(0).func_177958_n(), this.farmAbleLand.get(0).func_177956_o() - 1, this.farmAbleLand.get(0).func_177952_p())).func_177230_c() != Blocks.field_150458_ak) {
                this.delay = 20;
                this.world.func_175656_a(new BlockPos(this.farmAbleLand.get(0).func_177958_n(), this.farmAbleLand.get(0).func_177956_o() - 1, this.farmAbleLand.get(0).func_177952_p()), Blocks.field_150458_ak.func_176223_P());
                this.currentFarmLand = new BlockPos(this.farmAbleLand.get(0).func_177958_n(), this.farmAbleLand.get(0).func_177956_o() - 1, this.farmAbleLand.get(0).func_177952_p());
            }
            if (this.plowedLand.isEmpty() || !this.plowedLand.contains(new BlockPos(this.farmAbleLand.get(0).func_177958_n(), this.farmAbleLand.get(0).func_177956_o(), this.farmAbleLand.get(0).func_177952_p()))) {
                this.plowedLand.add(new BlockPos(this.farmAbleLand.get(0).func_177958_n(), this.farmAbleLand.get(0).func_177956_o(), this.farmAbleLand.get(0).func_177952_p()));
                this.farmAbleLand.remove(0);
            }
        } else if (this.plowedLand.isEmpty() && this.crops.isEmpty()) {
            ((JobFarmer)this.job).setStage(Stage.SEARCHING_LAND);
        } else {
            ((JobFarmer)this.job).setStage(Stage.WORKING);
        }
    }

    private void planting() {
        if (!this.plowedLand.isEmpty()) {
            if (this.world.func_180495_p(this.plowedLand.get(0)).func_177230_c() == Blocks.field_150458_ak) {
                if (this.world.func_175623_d(this.plowedLand.get(0))) {
                    this.world.func_175656_a(this.plowedLand.get(0), Blocks.field_150458_ak.func_176223_P());
                    this.delay = 20;
                    this.currentFarmLand = new BlockPos(this.plowedLand.get(0).func_177958_n(), this.plowedLand.get(0).func_177956_o() - 1, this.plowedLand.get(0).func_177952_p());
                    int slot = this.getFirstSeed();
                    ItemStack seed = this.getInventory().func_70301_a(slot);
                    if (seed == null) {
                        ((JobFarmer)this.job).setStage(Stage.WORKING);
                        return;
                    }
                    if (seed.func_77973_b() == Items.field_151014_N) {
                        BlockPosUtil.setBlock(this.world, this.plowedLand.get(0), Blocks.field_150464_aj);
                    } else if (seed.func_77973_b() == Items.field_151080_bb) {
                        BlockPosUtil.setBlock(this.world, this.plowedLand.get(0), Blocks.field_150393_bb);
                    } else if (seed.func_77973_b() == Items.field_151081_bc) {
                        BlockPosUtil.setBlock(this.world, this.plowedLand.get(0), Blocks.field_150394_bc);
                    } else if (seed.func_77973_b() == Items.field_151174_bG) {
                        BlockPosUtil.setBlock(this.world, this.plowedLand.get(0), Blocks.field_150469_bN);
                    } else if (seed.func_77973_b() == Items.field_151172_bF) {
                        BlockPosUtil.setBlock(this.world, this.plowedLand.get(0), Blocks.field_150459_bM);
                    }
                    this.getInventory().func_70298_a(slot, 1);
                    this.delay = 10;
                }
                if (this.crops.isEmpty() || !this.crops.contains(new BlockPos(this.plowedLand.get(0).func_177958_n(), this.plowedLand.get(0).func_177956_o(), this.plowedLand.get(0).func_177952_p()))) {
                    this.crops.add(new BlockPos(this.plowedLand.get(0).func_177958_n(), this.plowedLand.get(0).func_177956_o(), this.plowedLand.get(0).func_177952_p()));
                    this.plowedLand.remove(0);
                }
            } else if (this.farmAbleLand.isEmpty() || !this.farmAbleLand.contains(new BlockPos(this.plowedLand.get(0).func_177958_n(), this.plowedLand.get(0).func_177956_o(), this.plowedLand.get(0).func_177952_p()))) {
                this.farmAbleLand.add(new BlockPos(this.plowedLand.get(0).func_177958_n(), this.plowedLand.get(0).func_177956_o(), this.plowedLand.get(0).func_177952_p()));
                this.plowedLand.remove(0);
            }
        } else if (this.plowedLand.isEmpty() && this.crops.isEmpty()) {
            ((JobFarmer)this.job).setStage(Stage.SEARCHING_LAND);
        } else {
            ((JobFarmer)this.job).setStage(Stage.WORKING);
        }
    }

    private int getFirstSeed() {
        for (int slot = 0; slot < this.getInventory().func_70302_i_(); ++slot) {
            Item content;
            ItemStack stack = this.getInventory().func_70301_a(slot);
            if (stack == null || stack.func_77973_b() == null || !EntityAIWorkFarmer.isSeed(content = stack.func_77973_b())) continue;
            return slot;
        }
        return -1;
    }

    private void harvesting() {
        if (!this.crops.isEmpty()) {
            this.delay = 10;
            Block block = BlockPosUtil.getBlock(this.world, this.crops.get(0));
            if (BlockPosUtil.isWorkerAtSiteWithMove(this.worker, this.crops.get(0))) {
                if (block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || (Integer)this.world.func_180495_p(this.crops.get(0)).func_177229_b((IProperty)BlockCrops.field_176488_a) == 7) {
                    List<ItemStack> items = BlockPosUtil.getBlockDrops(this.world, this.crops.get(0), 0);
                    for (ItemStack item : items) {
                        InventoryUtils.setStack(this.getInventory(), item);
                    }
                    this.world.func_175698_g(this.crops.get(0));
                    ++this.harvestCounter;
                    if (!this.plowedLand.contains(this.crops.get(0))) {
                        this.plowedLand.add(new BlockPos((Vec3i)this.crops.get(0)));
                        this.crops.remove(0);
                    }
                } else {
                    this.crops2.add(this.crops.get(0));
                    this.crops.remove(0);
                }
            }
        } else if (this.plowedLand.isEmpty() && this.crops.isEmpty()) {
            ((JobFarmer)this.job).setStage(Stage.SEARCHING_LAND);
        } else {
            ((JobFarmer)this.job).setStage(Stage.WORKING);
        }
        if (this.harvestCounter == 15) {
            ((JobFarmer)this.job).setStage(Stage.FULL_INVENTORY);
            this.harvestCounter = 0;
        }
    }

    private boolean hasSeedInHut() {
        if (this.worker.getWorkBuilding().getTileEntity() == null) {
            return false;
        }
        int size = this.worker.getWorkBuilding().getTileEntity().func_70302_i_();
        for (int i = 0; i < size; ++i) {
            Item content;
            ItemStack stack = this.worker.getWorkBuilding().getTileEntity().func_70301_a(i);
            if (stack == null || !EntityAIWorkFarmer.isSeed(content = stack.func_77973_b())) continue;
            ItemStack returnStack = InventoryUtils.setStack(this.getInventory(), stack);
            if (returnStack == null) {
                this.worker.getWorkBuilding().getTileEntity().func_70298_a(i, stack.field_77994_a);
            } else {
                this.worker.getWorkBuilding().getTileEntity().func_70298_a(i, stack.field_77994_a - returnStack.field_77994_a);
            }
            return true;
        }
        return false;
    }

    private void dumpInventory() {
        if (BlockPosUtil.isWorkerAtSiteWithMove(this.worker, this.worker.getWorkBuilding().getLocation())) {
            for (int i = 0; i < this.getInventory().func_70302_i_(); ++i) {
                ItemStack stack = this.getInventory().func_70301_a(i);
                if (stack == null || EntityAIWorkFarmer.isStackTool(stack) || this.worker.getWorkBuilding().getTileEntity() == null) continue;
                ItemStack returnStack = InventoryUtils.setStack((IInventory)this.worker.getWorkBuilding().getTileEntity(), stack);
                if (returnStack == null) {
                    this.getInventory().func_70298_a(i, stack.field_77994_a);
                    continue;
                }
                this.getInventory().func_70298_a(i, stack.field_77994_a - returnStack.field_77994_a);
            }
            ((JobFarmer)this.job).setStage(Stage.WORKING);
        }
    }

    private static boolean isStackTool(ItemStack stack) {
        return stack != null && (stack.func_77977_a().contains(TOOL_TYPE_HOE) || stack.func_77973_b().getToolClasses(stack).contains(TOOL_TYPE_SHOVEL));
    }

    public static enum Stage {
        WORKING,
        MAKING_LAND,
        PLANTING,
        NEED_SEEDS,
        HARVESTING,
        SEARCHING_LAND,
        FULL_INVENTORY;

    }
}

