/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.pathfinding;

import net.minecraft.util.BlockPos;

public class Node
implements Comparable<Node> {
    public Node parent;
    public final BlockPos pos;
    private final int hash;
    public int counterAdded;
    public int counterVisited;
    public int steps;
    public double cost;
    public double heuristic;
    public double score;
    public boolean closed = false;
    public boolean isLadder = false;
    public boolean isSwimming = false;

    public Node(Node parent, BlockPos pos, double cost, double heuristic, double score) {
        this.parent = parent;
        this.pos = pos;
        this.steps = parent != null ? parent.steps + 1 : 0;
        this.cost = cost;
        this.heuristic = heuristic;
        this.score = score;
        this.hash = pos.func_177958_n() ^ (pos.func_177952_p() << 12 | pos.func_177952_p() >> 20) ^ pos.func_177956_o() << 24;
    }

    public Node(BlockPos pos, double heuristic) {
        this(null, pos, 0.0, heuristic, heuristic);
    }

    @Override
    public int compareTo(Node o) {
        if (this.score < o.score) {
            return -1;
        }
        if (this.score > o.score) {
            return 1;
        }
        if (this.heuristic < o.heuristic) {
            return -1;
        }
        if (this.heuristic > o.heuristic) {
            return 1;
        }
        return this.counterAdded - o.counterAdded;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            Node other = (Node)o;
            return this.pos.func_177958_n() == other.pos.func_177958_n() && this.pos.func_177956_o() == other.pos.func_177956_o() && this.pos.func_177952_p() == other.pos.func_177952_p();
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }
}

