/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.pathfinding;

import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.pathfinding.AbstractPathJob;
import com.minecolonies.entity.pathfinding.Node;
import com.minecolonies.util.Log;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class PathJobMoveToLocation
extends AbstractPathJob {
    private final BlockPos destination;
    private static final float DESTINATION_SLACK_NONE = 0.1f;
    private static final float DESTINATION_SLACK_ADJACENT = 3.1f;
    private float destinationSlack = 0.1f;
    private static final double TIE_BREAKER = 1.001;

    public PathJobMoveToLocation(World world, BlockPos start, BlockPos end, int range) {
        super(world, start, end, range);
        this.destination = new BlockPos((Vec3i)end);
    }

    @Override
    protected PathEntity search() {
        if (Configurations.pathfindingDebugVerbosity > 0) {
            Log.logger.info(String.format("Pathfinding from [%d,%d,%d] to [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.destination.func_177958_n(), this.destination.func_177956_o(), this.destination.func_177952_p()));
        }
        if (this.getGroundHeight(null, this.destination) != this.destination.func_177956_o()) {
            this.destinationSlack = 3.1f;
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        int dx = pos.func_177958_n() - this.destination.func_177958_n();
        int dy = pos.func_177956_o() - this.destination.func_177956_o();
        int dz = pos.func_177952_p() - this.destination.func_177952_p();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 1.001;
    }

    @Override
    protected boolean isAtDestination(Node n) {
        if (this.destinationSlack <= 0.1f) {
            return n.pos.func_177958_n() == this.destination.func_177958_n() && n.pos.func_177956_o() == this.destination.func_177956_o() && n.pos.func_177952_p() == this.destination.func_177952_p();
        }
        return this.destination.func_177954_c((double)n.pos.func_177958_n(), (double)n.pos.func_177956_o(), (double)n.pos.func_177952_p()) <= (double)this.destinationSlack;
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return -this.destination.func_177954_c((double)n.pos.func_177958_n(), (double)n.pos.func_177956_o(), (double)n.pos.func_177952_p());
    }
}

