/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.pathfinding;

public class PathResult {
    protected volatile Status status = Status.IN_PROGRESS_COMPUTING;
    protected volatile boolean pathReachesDestination = false;
    protected volatile int pathLength = 0;

    public void setStatus(Status s) {
        this.status = s;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isInProgress() {
        return this.isComputing() || this.status == Status.IN_PROGRESS_FOLLOWING;
    }

    public boolean failedToReachDestination() {
        return !this.isComputing() && !this.getPathReachesDestination();
    }

    public boolean isCancelled() {
        return this.status == Status.CANCELLED;
    }

    public void setPathReachesDestination(boolean value) {
        this.pathReachesDestination = value;
    }

    public boolean getPathReachesDestination() {
        return this.pathReachesDestination;
    }

    public void setPathLength(int l) {
        this.pathLength = l;
    }

    public int getPathLength() {
        return this.pathLength;
    }

    public boolean didPathGenerate() {
        return this.pathLength > 0;
    }

    public boolean isComputing() {
        return this.status == Status.IN_PROGRESS_COMPUTING;
    }

    static enum Status {
        IN_PROGRESS_COMPUTING,
        IN_PROGRESS_FOLLOWING,
        COMPLETE,
        CANCELLED;

    }
}

