/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.event;

import com.minecolonies.blocks.AbstractBlockHut;
import com.minecolonies.blocks.BlockHutTownHall;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.IColony;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.entity.PlayerProperties;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.MathUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.world;
        if (!world.field_72995_K && event.state.func_177230_c() instanceof AbstractBlockHut) {
            AbstractBuilding building = ColonyManager.getBuilding(world, event.pos);
            if (building == null) {
                return;
            }
            if (!building.getColony().getPermissions().hasPermission(event.getPlayer(), Permissions.Action.BREAK_HUTS)) {
                event.setCanceled(true);
                return;
            }
            building.destroy();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            EntityPlayer player = event.entityPlayer;
            World world = event.world;
            if (EventHandler.playerRightClickInteract(player, world, event.pos) && world.func_180495_p(event.pos).func_177230_c() instanceof AbstractBlockHut) {
                IColony colony = ColonyManager.getIColony(world, event.pos);
                if (colony != null && !colony.getPermissions().hasPermission(player, Permissions.Action.ACCESS_HUTS)) {
                    event.setCanceled(true);
                }
                return;
            }
            if (player.func_70694_bm() == null || player.func_70694_bm().func_77973_b() == null) {
                return;
            }
            this.handleEventCancellation(event, player);
        }
    }

    private void handleEventCancellation(PlayerInteractEvent event, EntityPlayer player) {
        Block heldBlock = Block.func_149634_a((Item)player.func_70694_bm().func_77973_b());
        if (heldBlock instanceof AbstractBlockHut) {
            event.setCanceled(!EventHandler.onBlockHutPlaced(event.world, player, heldBlock, event.pos.func_177972_a(event.face)));
        }
    }

    private static boolean playerRightClickInteract(EntityPlayer player, World world, BlockPos pos) {
        return !player.func_70093_af() || player.func_70694_bm() == null || player.func_70694_bm().func_77973_b() == null || player.func_70694_bm().func_77973_b().doesSneakBypassUse(world, pos, player);
    }

    public static boolean onBlockHutPlaced(World world, EntityPlayer player, Block block, BlockPos pos) {
        if (block instanceof BlockHutTownHall) {
            return EventHandler.onTownHallPlaced(world, player, pos);
        }
        return EventHandler.onBlockHutPlaced(world, player, pos);
    }

    static boolean onTownHallPlaced(World world, EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColonyByOwner(world, player);
        if (colony != null) {
            return EventHandler.canOwnerPlaceTownHallHere(world, player, colony, pos);
        }
        colony = ColonyManager.getClosestIColony(world, pos);
        if (colony == null) {
            EventHandler.createColony(world, player, pos);
            return true;
        }
        return EventHandler.canPlayerPlaceTownHallHere(world, player, pos, colony);
    }

    private static boolean canOwnerPlaceTownHallHere(World world, EntityPlayer player, IColony colony, BlockPos pos) {
        if (!colony.isCoordInColony(world, pos) || colony.hasTownHall()) {
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHutTownHall.messagePlacedAlready", new Object[0]);
            return false;
        }
        IColony currentColony = ColonyManager.getIColony(world, pos);
        if (currentColony != colony) {
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHutTownhall.messageTooFar", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean canPlayerPlaceTownHallHere(World world, EntityPlayer player, BlockPos pos, IColony closestColony) {
        if (closestColony.isCoordInColony(world, pos)) {
            if (closestColony.hasTownHall() || !closestColony.getPermissions().isColonyMember(player)) {
                LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
                return false;
            }
            if (!closestColony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
                LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHut.messageNoPermissionPlace", closestColony.getName());
                return false;
            }
            return true;
        }
        if ((double)closestColony.getDistanceSquared(pos) <= MathUtils.square(ColonyManager.getMinimumDistanceBetweenTownHalls())) {
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHutTownHall.messageTooClose", new Object[0]);
            return false;
        }
        EventHandler.createColony(world, player, pos);
        return true;
    }

    private static void createColony(World world, EntityPlayer player, BlockPos pos) {
        if (!world.field_72995_K) {
            ColonyManager.createColony(world, pos, player);
        }
    }

    private static boolean onBlockHutPlaced(World world, EntityPlayer player, BlockPos pos) {
        IColony colony = ColonyManager.getIColony(world, pos);
        if (colony == null) {
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHut.messageNoTownHall", new Object[0]);
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
            LanguageHandler.sendPlayerLocalizedMessage(player, "tile.blockHut.messageNoPermission", colony.getName());
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        EntityPlayer player;
        if (event.entity instanceof EntityPlayer && PlayerProperties.get(player = (EntityPlayer)event.entity) == null) {
            PlayerProperties.register(player);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            PlayerProperties.saveProxyData((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            PlayerProperties.loadProxyData((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        ColonyManager.onWorldLoad(event.world);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        ColonyManager.onWorldUnload(event.world);
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        ColonyManager.onWorldSave(event.world);
    }
}

