/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ColonyViewCitizenViewMessage
implements IMessage,
IMessageHandler<ColonyViewCitizenViewMessage, IMessage> {
    private int colonyId;
    private int citizenId;
    private ByteBuf citizenBuffer;

    public ColonyViewCitizenViewMessage() {
    }

    public ColonyViewCitizenViewMessage(Colony colony, CitizenData citizen) {
        this.colonyId = colony.getID();
        this.citizenId = citizen.getId();
        this.citizenBuffer = Unpooled.buffer();
        citizen.serializeViewNetworkData(this.citizenBuffer);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
        buf.writeBytes(this.citizenBuffer);
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
        this.citizenBuffer = Unpooled.buffer();
        buf.readBytes(this.citizenBuffer, buf.readableBytes());
    }

    public IMessage onMessage(ColonyViewCitizenViewMessage message, MessageContext ctx) {
        return ColonyManager.handleColonyViewCitizensMessage(message.colonyId, message.citizenId, message.citizenBuffer);
    }
}

