/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class HireFireMessage
implements IMessage,
IMessageHandler<HireFireMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean hire;
    private int citizenID;

    public HireFireMessage() {
    }

    public HireFireMessage(AbstractBuilding.View building, boolean hire, int citizenID) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.hire = hire;
        this.citizenID = citizenID;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBoolean(this.hire);
        buf.writeInt(this.citizenID);
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.hire = buf.readBoolean();
        this.citizenID = buf.readInt();
    }

    public IMessage onMessage(HireFireMessage message, MessageContext ctx) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (message.hire) {
                CitizenData citizen = colony.getCitizen(message.citizenID);
                ((AbstractBuildingWorker)colony.getBuilding(message.buildingId)).setWorker(citizen);
            } else {
                ((AbstractBuildingWorker)colony.getBuilding(message.buildingId)).setWorker(null);
            }
        }
        return null;
    }
}

