/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.CitizenDataView;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.inventory.InventoryCitizen;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class OpenInventoryMessage
implements IMessage,
IMessageHandler<OpenInventoryMessage, IMessage> {
    private static final int IpumpkinNVENTORY_NULL = -1;
    private static final int INVENTORY_CITIZEN = 0;
    private static final int INVENTORY_CHEST = 1;
    private String name;
    private int inventoryType;
    private int entityID;
    private BlockPos tePos;

    public OpenInventoryMessage() {
    }

    public OpenInventoryMessage(CitizenDataView citizen) {
        this.inventoryType = 0;
        this.name = citizen.getName();
        this.entityID = citizen.getEntityId();
    }

    public OpenInventoryMessage(AbstractBuilding.View building) {
        this.inventoryType = 1;
        this.name = "";
        this.tePos = building.getLocation();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.inventoryType);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        switch (this.inventoryType) {
            case 0: {
                buf.writeInt(this.entityID);
                break;
            }
            case 1: {
                BlockPosUtil.writeToByteBuf(buf, this.tePos);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.inventoryType = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        switch (this.inventoryType) {
            case 0: {
                this.entityID = buf.readInt();
                break;
            }
            case 1: {
                this.tePos = BlockPosUtil.readFromByteBuf(buf);
            }
        }
    }

    public IMessage onMessage(OpenInventoryMessage message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        switch (message.inventoryType) {
            case 0: {
                InventoryCitizen citizenInventory = ((EntityCitizen)player.field_70170_p.func_73045_a(message.entityID)).getInventoryCitizen();
                if (!StringUtils.func_151246_b((String)message.name)) {
                    citizenInventory.setCustomName(message.name);
                }
                player.func_71007_a((IInventory)citizenInventory);
                break;
            }
            case 1: {
                TileEntityChest chest = (TileEntityChest)BlockPosUtil.getTileEntity(player.field_70170_p, message.tePos);
                if (!StringUtils.func_151246_b((String)message.name)) {
                    chest.func_145976_a(message.name);
                }
                player.func_71007_a((IInventory)chest);
            }
        }
        return null;
    }
}

