/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.ColonyView;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ToggleJobMessage
implements IMessage,
IMessageHandler<ToggleJobMessage, IMessage> {
    private int colonyId;
    private boolean toggle;

    public ToggleJobMessage() {
    }

    public ToggleJobMessage(ColonyView colony, boolean toggle) {
        this.colonyId = colony.getID();
        this.toggle = toggle;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.toggle);
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.toggle = buf.readBoolean();
    }

    public IMessage onMessage(ToggleJobMessage message, MessageContext ctx) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            colony.setManualHiring(message.toggle);
        }
        return null;
    }
}

