/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.permissions.Permissions;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class WorkOrderChangeMessage
implements IMessage,
IMessageHandler<WorkOrderChangeMessage, IMessage> {
    private int colonyId;
    private int workOrderId;
    private int priority;
    private boolean removeWorkOrder;

    public WorkOrderChangeMessage() {
    }

    public WorkOrderChangeMessage(AbstractBuilding.View building, int workOrderId, boolean removeWorkOrder, int priority) {
        this.colonyId = building.getColony().getID();
        this.workOrderId = workOrderId;
        this.removeWorkOrder = removeWorkOrder;
        this.priority = priority;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.workOrderId);
        buf.writeInt(this.priority);
        buf.writeBoolean(this.removeWorkOrder);
    }

    public void fromBytes(ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.workOrderId = buf.readInt();
        this.priority = buf.readInt();
        this.removeWorkOrder = buf.readBoolean();
    }

    public IMessage onMessage(WorkOrderChangeMessage message, MessageContext ctx) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null && colony.getPermissions().hasPermission((EntityPlayer)ctx.getServerHandler().field_147369_b, Permissions.Action.ACCESS_HUTS)) {
            if (message.removeWorkOrder) {
                colony.getWorkManager().removeWorkOrder(message.workOrderId);
            } else {
                colony.getWorkManager().getWorkOrder(message.workOrderId).setPriority(message.priority);
            }
        }
        return null;
    }
}

