/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.util;

import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.entity.pathfinding.PathResult;
import com.minecolonies.util.EntityUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class BlockPosUtil {
    private static final double CLOSE_DISTANCE = 4.84;

    private BlockPosUtil() {
    }

    public static void writeToNBT(NBTTagCompound compound, String name, BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.func_74768_a("x", pos.func_177958_n());
        coordsCompound.func_74768_a("y", pos.func_177956_o());
        coordsCompound.func_74768_a("z", pos.func_177952_p());
        compound.func_74782_a(name, (NBTBase)coordsCompound);
    }

    public static BlockPos readFromNBT(NBTTagCompound compound, String name) {
        NBTTagCompound coordsCompound = compound.func_74775_l(name);
        int x = coordsCompound.func_74762_e("x");
        int y = coordsCompound.func_74762_e("y");
        int z = coordsCompound.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToNBTTagList(NBTTagList tagList, BlockPos pos) {
        NBTTagCompound coordsCompound = new NBTTagCompound();
        coordsCompound.func_74768_a("x", pos.func_177958_n());
        coordsCompound.func_74768_a("y", pos.func_177956_o());
        coordsCompound.func_74768_a("z", pos.func_177952_p());
        tagList.func_74742_a((NBTBase)coordsCompound);
    }

    public static BlockPos readFromNBTTagList(NBTTagList tagList, int index) {
        NBTTagCompound coordsCompound = tagList.func_150305_b(index);
        int x = coordsCompound.func_74762_e("x");
        int y = coordsCompound.func_74762_e("y");
        int z = coordsCompound.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToByteBuf(ByteBuf buf, BlockPos pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    public static BlockPos readFromByteBuf(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        return new BlockPos(x, y, z);
    }

    public static boolean isClose(BlockPos coordinate, EntityCitizen citizen) {
        return (double)BlockPosUtil.getDistanceSquared(coordinate, citizen.func_180425_c()) < 4.84;
    }

    public static int getDistanceSquared(BlockPos block1, BlockPos block2) {
        int i = block1.func_177958_n() - block2.func_177958_n();
        int i1 = block1.func_177956_o() - block2.func_177956_o();
        int i2 = block1.func_177952_p() - block2.func_177952_p();
        return i * i + i1 * i1 + i2 * i2;
    }

    public static TileEntity getTileEntity(World world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public static List<ItemStack> getBlockDrops(World world, BlockPos coords, int fortune) {
        return BlockPosUtil.getBlock(world, coords).getDrops((IBlockAccess)world, new BlockPos(coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()), BlockPosUtil.getBlockState(world, coords), fortune);
    }

    public static Block getBlock(World world, BlockPos coords) {
        return world.func_180495_p(coords).func_177230_c();
    }

    public static IBlockState getBlockState(World world, BlockPos coords) {
        return world.func_180495_p(coords);
    }

    public static boolean setBlock(World world, BlockPos coords, Block block) {
        return world.func_175656_a(coords, block.func_176223_P());
    }

    public static boolean setBlock(World worldIn, BlockPos coords, IBlockState state, int flag) {
        return worldIn.func_180501_a(coords, state, flag);
    }

    public static boolean isPathingTo(EntityCitizen citizen, BlockPos pos) {
        return EntityUtils.isPathingTo(citizen, pos.func_177958_n(), pos.func_177952_p());
    }

    public static boolean isWorkerAtSiteWithMove(EntityCitizen worker, BlockPos site) {
        return EntityUtils.isWorkerAtSiteWithMove(worker, site.func_177958_n(), site.func_177956_o(), site.func_177952_p());
    }

    public static boolean isWorkerAtSiteWithMove(EntityCitizen worker, BlockPos site, int range) {
        return EntityUtils.isWorkerAtSiteWithMove(worker, site.func_177958_n(), site.func_177956_o(), site.func_177952_p(), range);
    }

    public static boolean tryMoveLivingToXYZ(EntityLiving living, BlockPos destination) {
        return EntityUtils.tryMoveLivingToXYZ(living, destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p());
    }

    public static PathResult moveLivingToXYZ(EntityCitizen citizen, BlockPos destination) {
        return citizen.getNavigator().moveToXYZ(destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p(), 1.0);
    }

    public static void set(BlockPos.MutableBlockPos pos, BlockPos newPos) {
        pos.func_181079_c(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
    }

    public static boolean isEqual(BlockPos coords, int x, int y, int z) {
        return coords.func_177958_n() == x && coords.func_177956_o() == y && coords.func_177952_p() == z;
    }

    public static BlockPos fromEntity(Entity entity) {
        return new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v));
    }
}

