/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.util;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.registry.LanguageRegistry;

public class LanguageHandler {
    public static void sendPlayerLocalizedMessage(EntityPlayer player, String key, Object ... args) {
        LanguageHandler.sendPlayerMessage(player, LanguageHandler.format(key, args));
    }

    public static String format(String key, Object ... args) {
        return String.format(LanguageHandler.getString(key), args);
    }

    public static String getString(String key) {
        return LanguageHandler.getString(key, key);
    }

    public static String getString(String key, String defaultValue) {
        String value = LanguageRegistry.instance().getStringLocalization(key);
        return "".equals(value) ? defaultValue : value;
    }

    public static void sendPlayerMessage(EntityPlayer player, String message) {
        player.func_146105_b((IChatComponent)new ChatComponentText(message));
    }

    public static void sendPlayersLocalizedMessage(List<EntityPlayer> players, String key, Object ... args) {
        LanguageHandler.sendPlayersMessage(players, LanguageHandler.format(key, args));
    }

    public static void sendPlayersMessage(List<EntityPlayer> players, String message) {
        if (players == null || players.isEmpty()) {
            return;
        }
        for (EntityPlayer player : players) {
            LanguageHandler.sendPlayerMessage(player, message);
        }
    }
}

