/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.util;

import com.minecolonies.blocks.AbstractBlockHut;
import com.minecolonies.blocks.ModBlocks;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.BlockUtils;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import com.schematica.client.util.RotationHelper;
import com.schematica.world.schematic.SchematicFormat;
import com.schematica.world.storage.Schematic;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SchematicWrapper {
    private World world;
    private Schematic schematicWorld;
    private BlockPos position;
    private String name;
    private static final BlockPos NULL_POS = new BlockPos(-1, -1, -1);
    private final BlockPos.MutableBlockPos progressPos = new BlockPos.MutableBlockPos(-1, -1, -1);
    private static final int NUMBER_OF_ROTATIONS = 4;
    private static final int REVERSE_ROTATION = 3;
    private static final int TWO_FOR_HALVING = 2;
    private static final ItemStack DEFUALT_ICON = new ItemStack((Block)Blocks.field_150337_Q);

    public SchematicWrapper(World worldObj, String name) {
        this(worldObj, SchematicWrapper.getResourceLocation(name), name);
    }

    private SchematicWrapper(World worldObj, ResourceLocation res, String name) {
        this(worldObj, SchematicFormat.readFromStream(SchematicWrapper.getStream(res)), name);
    }

    private SchematicWrapper(World worldObj, Schematic schematicWorld, String name) {
        this.world = worldObj;
        this.schematicWorld = schematicWorld;
        this.name = name;
    }

    private static InputStream getStream(ResourceLocation res) {
        try {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return Minecraft.func_71410_x().func_110442_L().func_110536_a(res).func_110527_b();
            }
            return SchematicWrapper.class.getResourceAsStream(String.format("/assets/%s/%s", res.func_110624_b(), res.func_110623_a()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load stream!", e);
        }
    }

    private static ResourceLocation getResourceLocation(@NotNull String name) {
        return new ResourceLocation("minecolonies:schematics/" + name + ".schematic");
    }

    public static void loadAndPlaceSchematicWithRotation(World worldObj, String name, BlockPos pos, int rotations) {
        try {
            SchematicWrapper schematic = new SchematicWrapper(worldObj, name);
            schematic.rotate(rotations);
            schematic.placeSchematic(pos);
        }
        catch (IllegalStateException e) {
            Log.logger.warn("Could not load schematic!", (Throwable)e);
        }
    }

    private void placeSchematic(BlockPos pos) {
        this.setLocalPosition(pos);
        ArrayList<BlockPos> delayedBlocks = new ArrayList<BlockPos>();
        for (int j = 0; j < this.schematicWorld.getHeight(); ++j) {
            for (int k = 0; k < this.schematicWorld.getLength(); ++k) {
                for (int i = 0; i < this.schematicWorld.getWidth(); ++i) {
                    BlockPos localPos = new BlockPos(i, j, k);
                    IBlockState localState = this.schematicWorld.getBlockState(localPos);
                    Block localBlock = localState.func_177230_c();
                    BlockPos worldPos = pos.func_177971_a((Vec3i)localPos);
                    IBlockState worldState = this.world.func_180495_p(worldPos);
                    if (localBlock == ModBlocks.blockSubstitution) continue;
                    if (localBlock == Blocks.field_150350_a && !worldState.func_177230_c().func_149688_o().func_76220_a()) {
                        this.world.func_175698_g(worldPos);
                    } else if (localBlock.func_149688_o().func_76220_a()) {
                        this.placeBlock(localState, localBlock, worldPos);
                    } else {
                        delayedBlocks.add(localPos);
                    }
                    this.world.func_175690_a(worldPos, this.schematicWorld.getTileEntity(localPos));
                }
            }
        }
        for (BlockPos coords : delayedBlocks) {
            IBlockState localState = this.schematicWorld.getBlockState(coords);
            Block localBlock = localState.func_177230_c();
            BlockPos newWorldPos = pos.func_177971_a((Vec3i)coords);
            this.placeBlock(localState, localBlock, newWorldPos);
        }
    }

    private void placeBlock(IBlockState localState, Block localBlock, BlockPos worldPos) {
        this.world.func_180501_a(worldPos, localState, 3);
        if (this.world.func_180495_p(worldPos).func_177230_c() == localBlock) {
            if (this.world.func_180495_p(worldPos) != localState) {
                this.world.func_180501_a(worldPos, localState, 3);
            }
            localBlock.func_176213_c(this.world, worldPos, localState);
        }
    }

    private void rotate(EnumFacing facing) {
        try {
            this.schematicWorld = RotationHelper.rotate(this.schematicWorld, facing, true);
        }
        catch (RotationHelper.RotationException e) {
            Log.logger.debug((Object)e);
        }
    }

    public void rotate(int times) {
        if (times % 4 == 3) {
            this.rotate(EnumFacing.DOWN);
        } else {
            for (int i = 0; i < times; ++i) {
                this.rotate(EnumFacing.UP);
            }
        }
    }

    public static String saveSchematic(World world, BlockPos from, BlockPos to) {
        if (world == null || from == null || to == null) {
            throw new IllegalArgumentException("Invalid method call, arguments can't be null. Contact a developer.");
        }
        Schematic schematic = SchematicWrapper.scanSchematic(world, from, to);
        String fileName = LanguageHandler.format("item.scepterSteel.scanFormat", schematic.getType(), System.currentTimeMillis());
        File file = new File(SchematicWrapper.getScanDirectory(world), fileName);
        if (SchematicFormat.writeToFile(file, schematic)) {
            return LanguageHandler.format("item.scepterSteel.scanSuccess", fileName);
        }
        return LanguageHandler.format("item.scepterSteel.scanFailure", new Object[0]);
    }

    private static File getScanDirectory(World world) {
        File minecolonies = world.field_72995_K ? new File(Minecraft.func_71410_x().field_71412_D, "minecolonies/") : MinecraftServer.func_71276_C().func_71209_f("minecolonies/");
        SchematicWrapper.checkDirectory(minecolonies);
        File scans = new File(minecolonies, "scans/");
        SchematicWrapper.checkDirectory(scans);
        return scans;
    }

    private static void checkDirectory(File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.logger.error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }

    private static Schematic scanSchematic(World world, BlockPos from, BlockPos to) {
        int minX = Math.min(from.func_177958_n(), to.func_177958_n());
        int maxX = Math.max(from.func_177958_n(), to.func_177958_n());
        int minY = Math.min(from.func_177956_o(), to.func_177956_o());
        int maxY = Math.max(from.func_177956_o(), to.func_177956_o());
        int minZ = Math.min(from.func_177952_p(), to.func_177952_p());
        int maxZ = Math.max(from.func_177952_p(), to.func_177952_p());
        short width = (short)(Math.abs(maxX - minX) + 1);
        short height = (short)(Math.abs(maxY - minY) + 1);
        short length = (short)(Math.abs(maxZ - minZ) + 1);
        BlockPos minPos = new BlockPos(minX, minY, minZ);
        Schematic schematic = new Schematic(DEFUALT_ICON, width, height, length);
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos worldPos = new BlockPos(x, y, z);
                    BlockPos localPos = worldPos.func_177973_b((Vec3i)minPos);
                    IBlockState blockState = world.func_180495_p(worldPos);
                    schematic.setBlockState(localPos, blockState);
                    if (blockState.func_177230_c() instanceof AbstractBlockHut) {
                        if (BlockPosUtil.isEqual((BlockPos)offset, 0, 0, 0)) {
                            BlockPosUtil.set(offset, localPos);
                        } else {
                            schematic.setBlockState(localPos, Blocks.field_150350_a.func_176223_P());
                            Log.logger.warn("Scan contained multiple AbstractBlockHut's ignoring this one");
                        }
                    }
                    TileEntity tileEntity = world.func_175625_s(worldPos);
                    SchematicWrapper.saveTileEntity(schematic, tileEntity, minPos);
                }
            }
        }
        if (BlockPosUtil.isEqual((BlockPos)offset, 0, 0, 0)) {
            offset.func_181079_c(width / 2, 0, length / 2);
        }
        schematic.setOffset((BlockPos)offset);
        AxisAlignedBB region = AxisAlignedBB.func_178781_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        world.func_72872_a(EntityHanging.class, region).forEach(schematic::addEntity);
        world.func_72872_a(EntityMinecart.class, region).forEach(schematic::addEntity);
        return schematic;
    }

    private static void saveTileEntity(Schematic schematic, TileEntity tileEntity, BlockPos minPos) {
        if (tileEntity != null) {
            BlockPos newPos = tileEntity.func_174877_v().func_177973_b((Vec3i)minPos);
            NBTTagCompound tileEntityNBT = new NBTTagCompound();
            tileEntity.func_145841_b(tileEntityNBT);
            TileEntity newTileEntity = TileEntity.func_145827_c((NBTTagCompound)tileEntityNBT);
            newTileEntity.func_174878_a(newPos);
            schematic.setTileEntity(newPos, newTileEntity);
        }
    }

    public boolean findNextBlock() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while (this.doesSchematicBlockEqualWorldBlock() && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    public boolean incrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c(-1, 0, 0);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() + 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == this.schematicWorld.getWidth()) {
            this.progressPos.func_181079_c(0, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() + 1);
            if (this.progressPos.func_177952_p() == this.schematicWorld.getLength()) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() + 1, 0);
                if (this.progressPos.func_177956_o() == this.schematicWorld.getHeight()) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    public boolean doesSchematicBlockEqualWorldBlock() {
        IBlockState schematicBlockState = this.schematicWorld.getBlockState(this.getLocalPosition());
        Block schematicBlock = schematicBlockState.func_177230_c();
        if (schematicBlock == ModBlocks.blockSubstitution) {
            return true;
        }
        BlockPos worldPos = this.getBlockPosition();
        IBlockState worldBlockState = this.world.func_180495_p(worldPos);
        if (schematicBlock instanceof BlockDoor || schematicBlock == Blocks.field_150457_bL) {
            return schematicBlock == worldBlockState.func_177230_c();
        }
        if (schematicBlock instanceof BlockStairs && BlockStairs.func_176302_a((IBlockAccess)this.world, (BlockPos)worldPos, (IBlockState)schematicBlockState)) {
            return true;
        }
        return worldPos.func_177956_o() <= 0 || schematicBlockState == worldBlockState;
    }

    public BlockPos getBlockPosition() {
        return this.progressPos.func_177971_a((Vec3i)this.getOffsetPosition());
    }

    public BlockPos getOffsetPosition() {
        return this.position.func_177973_b((Vec3i)this.getOffset());
    }

    public BlockPos getOffset() {
        return this.schematicWorld.getOffset();
    }

    public boolean findNextBlockToClear() {
        int count = 0;
        do {
            ++count;
            if (this.decrementBlock()) continue;
            return false;
        } while ((this.worldBlockAir() || this.doesSchematicBlockEqualWorldBlock()) && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    private boolean isAirBlock() {
        return this.getBlock() == Blocks.field_150350_a;
    }

    public boolean findNextBlockSolid() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while ((this.doesSchematicBlockEqualWorldBlock() || this.isBlockNonSolid()) && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    private boolean isBlockNonSolid() {
        return this.getBlock() != null && !this.getBlock().func_149688_o().func_76220_a();
    }

    public boolean findNextBlockNonSolid() {
        int count = 0;
        do {
            ++count;
            if (this.incrementBlock()) continue;
            return false;
        } while ((this.doesSchematicBlockEqualWorldBlock() || this.isBlockSolid()) && count < Configurations.maxBlocksCheckedByBuilder);
        return true;
    }

    private boolean isBlockSolid() {
        return this.getBlock() != null && this.getBlock().func_149688_o().func_76220_a();
    }

    public boolean decrementBlock() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.func_181079_c(this.schematicWorld.getWidth(), this.schematicWorld.getHeight() - 1, this.schematicWorld.getLength() - 1);
        }
        this.progressPos.func_181079_c(this.progressPos.func_177958_n() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p());
        if (this.progressPos.func_177958_n() == -1) {
            this.progressPos.func_181079_c(this.schematicWorld.getWidth() - 1, this.progressPos.func_177956_o(), this.progressPos.func_177952_p() - 1);
            if (this.progressPos.func_177952_p() == -1) {
                this.progressPos.func_181079_c(this.progressPos.func_177958_n(), this.progressPos.func_177956_o() - 1, this.schematicWorld.getLength() - 1);
                if (this.progressPos.func_177956_o() == -1) {
                    this.reset();
                    return false;
                }
            }
        }
        return true;
    }

    private boolean worldBlockAir() {
        BlockPos pos = this.getBlockPosition();
        return pos.func_177956_o() <= 0 || this.world.func_175623_d(pos);
    }

    @Nullable
    public IBlockState getBlockState() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.schematicWorld.getBlockState((BlockPos)this.progressPos);
    }

    @Nullable
    public TileEntity getTileEntity() {
        if (this.progressPos.equals((Object)NULL_POS)) {
            return null;
        }
        return this.schematicWorld.getTileEntity((BlockPos)this.progressPos);
    }

    public List<Entity> getEntities() {
        return this.schematicWorld.getEntities();
    }

    @NotNull
    public BlockPos getLocalPosition() {
        return this.progressPos.getImmutable();
    }

    public void setLocalPosition(BlockPos localPosition) {
        BlockPosUtil.set(this.progressPos, localPosition);
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    @Nullable
    public Item getItem() {
        Block block = this.getBlock();
        IBlockState blockState = this.getBlockState();
        if (block == null || blockState == null) {
            return null;
        }
        return BlockUtils.getItemStackFromBlockState(blockState).func_77973_b();
    }

    @Nullable
    public Block getBlock() {
        IBlockState state = this.getBlockState();
        if (state == null) {
            return null;
        }
        return state.func_177230_c();
    }

    public String getName() {
        return this.name;
    }

    public int getHeight() {
        return this.schematicWorld.getHeight();
    }

    public int getWidth() {
        return this.schematicWorld.getWidth();
    }

    public int getLength() {
        return this.schematicWorld.getLength();
    }

    public void reset() {
        BlockPosUtil.set(this.progressPos, NULL_POS);
    }

    public Schematic getSchematic() {
        return this.schematicWorld;
    }
}

