/*
 * Decompiled with CFR 0.152.
 */
package com.schematica.core.client.renderer;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockPos;

public final class GeometryTessellator
extends Tessellator {
    private static GeometryTessellator instance = null;
    private static double deltaS = 0.0;
    private double delta = 0.0;

    private GeometryTessellator() {
        super(0x200000);
    }

    public static synchronized GeometryTessellator getInstance() {
        if (instance == null) {
            instance = new GeometryTessellator();
        }
        return instance;
    }

    public void setTranslation(double x, double y, double z) {
        this.func_178180_c().func_178969_c(x, y, z);
    }

    public void beginQuads() {
        this.begin(7);
    }

    public void beginLines() {
        this.begin(1);
    }

    private void begin(int mode) {
        this.func_178180_c().func_181668_a(mode, DefaultVertexFormats.field_181706_f);
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public static void setStaticDelta(double delta) {
        deltaS = delta;
    }

    public void drawCuboid(BlockPos pos, int sides, int argb) {
        this.drawCuboid(pos, pos, sides, argb);
    }

    public void drawCuboid(BlockPos begin, BlockPos end, int sides, int argb) {
        GeometryTessellator.drawCuboid(this.func_178180_c(), begin, end, sides, argb, this.delta);
    }

    public static void drawCuboid(WorldRenderer worldRenderer, BlockPos pos, int sides, int argb) {
        GeometryTessellator.drawCuboid(worldRenderer, pos, pos, sides, argb);
    }

    private static void drawCuboid(WorldRenderer worldRenderer, BlockPos begin, BlockPos end, int sides, int argb) {
        GeometryTessellator.drawCuboid(worldRenderer, begin, end, sides, argb, deltaS);
    }

    private static void drawCuboid(WorldRenderer worldRenderer, BlockPos begin, BlockPos end, int sides, int argb, double delta) {
        if (worldRenderer.func_178979_i() == -1 || sides == 0) {
            return;
        }
        double x0 = (double)begin.func_177958_n() - delta;
        double y0 = (double)begin.func_177956_o() - delta;
        double z0 = (double)begin.func_177952_p() - delta;
        double x1 = (double)(end.func_177958_n() + 1) + delta;
        double y1 = (double)(end.func_177956_o() + 1) + delta;
        double z1 = (double)(end.func_177952_p() + 1) + delta;
        switch (worldRenderer.func_178979_i()) {
            case 7: {
                GeometryTessellator.drawQuads(worldRenderer, x0, y0, z0, x1, y1, z1, sides, argb);
                break;
            }
            case 1: {
                GeometryTessellator.drawLines(worldRenderer, x0, y0, z0, x1, y1, z1, sides, argb);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mode!");
            }
        }
    }

    private static void drawQuads(WorldRenderer worldRenderer, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        GeometryTessellator.drawQuads(worldRenderer, x0, y0, z0, x1, y1, z1, sides, a, r, g, b);
    }

    private static void drawQuads(WorldRenderer worldRenderer, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int a, int r, int g, int b) {
        if ((sides & 1) != 0) {
            worldRenderer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 2) != 0) {
            worldRenderer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 4) != 0) {
            worldRenderer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 8) != 0) {
            worldRenderer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x10) != 0) {
            worldRenderer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x20) != 0) {
            worldRenderer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
    }

    private static void drawLines(WorldRenderer worldRenderer, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        GeometryTessellator.drawLines(worldRenderer, x0, y0, z0, x1, y1, z1, sides, a, r, g, b);
    }

    private static void drawLines(WorldRenderer worldRenderer, double x0, double y0, double z0, double x1, double y1, double z1, int sides, int a, int r, int g, int b) {
        if ((sides & 0x11) != 0) {
            worldRenderer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x12) != 0) {
            worldRenderer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x21) != 0) {
            worldRenderer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x22) != 0) {
            worldRenderer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 5) != 0) {
            worldRenderer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 6) != 0) {
            worldRenderer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 9) != 0) {
            worldRenderer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0xA) != 0) {
            worldRenderer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x14) != 0) {
            worldRenderer.func_181662_b(x0, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x24) != 0) {
            worldRenderer.func_181662_b(x1, y0, z0).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z0).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x18) != 0) {
            worldRenderer.func_181662_b(x0, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x0, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
        if ((sides & 0x28) != 0) {
            worldRenderer.func_181662_b(x1, y0, z1).func_181669_b(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(x1, y1, z1).func_181669_b(r, g, b, a).func_181675_d();
        }
    }
}

