package com.minecolonies.blockout;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

/**
 * Render utility functions.
 */
public final class Render
{
    private static final int    ALPHA_SHIFT   = 24;
    private static final int    RED_SHIFT     = 16;
    private static final int    GREEN_SHIFT   = 8;
    private static final int    COLOR_MASK    = 255;
    private static final double COLOR_DIVISOR = 255.0;

    private Render()
    {
        // Hide default constructor
    }

    /**
     * {@link Render#drawOutlineRect(int, int, int, int, float, int)}.
     *
     * @param x1    lower x
     * @param y1    lower y
     * @param x2    upper x
     * @param y2    upper y
     * @param color color
     */
    public static void drawOutlineRect(final int x1, final int y1, final int x2, final int y2, final int color)
    {
        drawOutlineRect(x1, y1, x2, y2, 1.0F, color);
    }

    /**
     * Draw an outlined untextured rectangle.
     *
     * @param x1        lower x
     * @param y1        lower y
     * @param x2        upper x
     * @param y2        upper y
     * @param lineWidth line thickness, default of 1.0
     * @param color     color
     */
    public static void drawOutlineRect(final int x1, final int y1, final int x2, final int y2, final float lineWidth, final int color)
    {
        final float a = (float) (((color >> ALPHA_SHIFT) & COLOR_MASK) / COLOR_DIVISOR);
        final float r = (float) (((color >> RED_SHIFT) & COLOR_MASK) / COLOR_DIVISOR);
        final float g = (float) (((color >> GREEN_SHIFT) & COLOR_MASK) / COLOR_DIVISOR);
        final float b = (float) ((color & COLOR_MASK) / COLOR_DIVISOR);

        final Tessellator tessellator = Tessellator.func_178181_a();
        final VertexBuffer vertexBuffer = tessellator.func_178180_c();

        vertexBuffer.func_181668_a(GL11.GL_LINE_LOOP, DefaultVertexFormats.field_181705_e);
        GlStateManager.func_179090_x();
        GL11.glLineWidth(lineWidth);
        GlStateManager.func_179131_c(r, g, b, a);

        //Since our points do not have any u,v this seems to be the correct code
        vertexBuffer.func_181662_b(x1, y2, 0.0D).func_181675_d();
        vertexBuffer.func_181662_b(x2, y2, 0.0D).func_181675_d();
        vertexBuffer.func_181662_b(x2, y1, 0.0D).func_181675_d();
        vertexBuffer.func_181662_b(x1, y1, 0.0D).func_181675_d();

        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }
}
