package com.minecolonies.blockout.controls;

import com.minecolonies.blockout.PaneParams;
import net.minecraft.client.renderer.GlStateManager;

/**
 * BlockOut label pane. Used to render a piece of text.
 */
public class Label extends AbstractTextElement
{
    /**
     * The text of the label.
     */
    protected String labelText;

    /**
     * The color the label has when hovering it with the mouse.
     */
    protected int hoverColor = 0xffffff;

    /**
     * Standard constructor which instantiates a new label.
     */
    public Label()
    {
        super();
        // Required default constructor.
    }

    /**
     * Create a label from xml.
     *
     * @param params xml parameters.
     */
    public Label(final PaneParams params)
    {
        super(params);
        labelText = params.getLocalizedStringAttribute("label", labelText);

        //  match textColor by default
        hoverColor = params.getColorAttribute("hovercolor", textColor);

        if (width == 0)
        {
            width = Math.min(mc.field_71466_p.func_78256_a(labelText), params.getParentWidth());
        }
    }

    public String getLabelText()
    {
        return labelText;
    }

    public void setLabelText(final String s)
    {
        labelText = s;
    }

    public int getHoverColor()
    {
        return hoverColor;
    }

    /**
     * Set the default and hover color for the label.
     *
     * @param c default color.
     * @param h hover color.
     */
    public void setColor(final int c, final int h)
    {
        setColor(c);
        hoverColor = h;
    }

    @Override
    public void drawSelf(final int mx, final int my)
    {
        final int color = isPointInPane(mx, my) ? hoverColor : textColor;

        int offsetX = 0;
        int offsetY = 0;

        if (textAlignment.isRightAligned())
        {
            offsetX = getWidth() - getStringWidth();
        }
        else if (textAlignment.isHorizontalCentered())
        {
            offsetX = (getWidth() - getStringWidth()) / 2;
        }

        if (textAlignment.isBottomAligned())
        {
            offsetY = getHeight() - getTextHeight();
        }
        else if (textAlignment.isVerticalCentered())
        {
            offsetY = (getHeight() - getTextHeight()) / 2;
        }

        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double) (getX() + offsetX), (double) (getY() + offsetY), 0);
        GlStateManager.func_179152_a((float) scale, (float) scale, (float) scale);
        mc.field_71446_o.func_110577_a(TEXTURE);
        mc.field_71466_p.func_175065_a(labelText, 0, 0, color, shadow);
        GlStateManager.func_179121_F();
    }

    /**
     * Getter of the width of the string.
     * @return the width.
     */
    public int getStringWidth()
    {
        return (int) (mc.field_71466_p.func_78256_a(labelText) * scale);
    }

    /**
     * Getter of the text height.
     * @return the text height.
     */
    public int getTextHeight()
    {
        return (int) (mc.field_71466_p.field_78288_b * scale);
    }
}
