package com.minecolonies.coremod.blocks;

import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.lib.Constants;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Random;

import static net.minecraft.util.EnumFacing.*;

/**
 * This Block has the same purpose as the BlockConstructionTape.
 * The only difference is: it's a corner piece.
 */
public class BlockConstructionTapeCorner extends Block
{

    /**
     * The position it faces.
     */
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    /**
     * The hardness this block has.
     */
    private static final float BLOCK_HARDNESS = 0.0F;

    /**
     * This blocks name.
     */
    private static final String BLOCK_NAME = "blockConstructionTapeCorner";

    /**
     * The resistance this block has.
     */
    private static final float RESISTANCE = 0.0F;

    /**
     * Start of the collision box at y.
     */
    private static final double BOTTOM_COLLISION = 0.0;

    /**
     * Start of the collision box at x facing North.
     */
    private static final double N_START_COLLISION_X = 0.0;

    /**
     * End of the collision box facing North.
     */
    private static final double N_END_COLLISION_X = 0.5625;

    /**
     * Start of the collision box at z facing North.
     */
    private static final double N_START_COLLISION_Z = 0.0;

    /**
     * End of the collision box facing North.
     */
    private static final double N_END_COLLISION_Z = 0.5625;

    /**
     * Start of the collision box at x facing West.
     */
    private static final double W_START_COLLISION_X = 0.0;

    /**
     * End of the collision box facing West.
     */
    private static final double W_END_COLLISION_X = 0.5625;

    /**
     * Start of the collision box at z facing West.
     */
    private static final double W_START_COLLISION_Z = 0.4375;

    /**
     * End of the collision box facing West.
     */
    private static final double W_END_COLLISION_Z = 1.0;

    /**
     * Start of the collision box at x facing South.
     */
    private static final double S_START_COLLISION_X = 0.4375;

    /**
     * End of the collision box facing South.
     */
    private static final double S_END_COLLISION_X = 1.0;

    /**
     * Start of the collision box at z facing South.
     */
    private static final double S_START_COLLISION_Z = 0.4375;

    /**
     * End of the collision box facing South.
     */
    private static final double S_END_COLLISION_Z = 1.0;

    /**
     * Start of the collision box at x facing East.
     */
    private static final double E_START_COLLISION_X = 0.4375;

    /**
     * End of the collision box facing East.
     */
    private static final double E_END_COLLISION_X = 1.0;

    /**
     * Start of the collision box at z facing East.
     */
    private static final double E_START_COLLISION_Z = 0.0;

    /**
     * End of the collision box facing East.
     */
    private static final double E_END_COLLISION_Z = 0.5625;

    /**
     * Height of the collision box.
     */
    private static final double HEIGHT_COLLISION = 1.0;
    /**
     * How much light goes through the block.
     */
    private static final int LIGHT_OPACITY = 0;

    /**
     * Constructor for the Substitution block.
     * sets the creative tab, as well as the resistance and the hardness.
     */
    public BlockConstructionTapeCorner()
    {
        super(Material.field_151582_l);
        initBlock();
    }


    /**
     * initialize the block
     * sets the creative tab, as well as the resistance and the hardness.
     */
    private void initBlock()
    {
        setRegistryName(BLOCK_NAME);
        func_149663_c(String.format("%s.%s", Constants.MOD_ID.toLowerCase(), BLOCK_NAME));
        func_149647_a(ModCreativeTabs.MINECOLONIES);
        GameRegistry.register(this);
        GameRegistry.register((new ItemBlock(this)).setRegistryName(this.getRegistryName()));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, EnumFacing.NORTH));
        func_149711_c(BLOCK_HARDNESS);
        func_149752_b(RESISTANCE);
        func_149713_g(LIGHT_OPACITY);
        field_149764_J.func_76231_i();
    }

    @Nullable
    @Override
    public Item func_180660_a(final IBlockState state, final Random rand, final int fortune)
    {
        return null;
    }
    
    /**
     * @deprecated (Remove this as soon as minecraft offers anything better).
     */

    @Override
    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos)
    {
        return null;
    }
    
    @Override
    public int func_176201_c(@NotNull final IBlockState state)
    {
        return state.func_177229_b(FACING).func_176745_a();
    }

    /**
     * Convert the given metadata into a BlockState for this Block.
     *
     * @deprecated (Remove this as soon as minecraft offers anything better).
     */
    @NotNull
    @Override
    @Deprecated
    public IBlockState func_176203_a(final int meta)
    {
        EnumFacing enumfacing = EnumFacing.func_82600_a(meta);

        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y)
        {
            enumfacing = EnumFacing.NORTH;
        }

        return this.func_176223_P().func_177226_a(FACING, enumfacing);
    }

    /**
     * @deprecated (Remove this as soon as minecraft offers anything better).
     */
    @SideOnly(Side.CLIENT)
    @Override
    @Deprecated
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side)
    {
        return true;
    }

    /**
     * @deprecated (Remove this as soon as minecraft offers anything better).
     */
    @Override
    @Deprecated
    public boolean func_149662_c(final IBlockState state)
    {
        return false;
    }

    @NotNull
    @Override
    protected BlockStateContainer func_180661_e()
    {
        return new BlockStateContainer(this, FACING);
    }

    @NotNull
    @Override
    @SideOnly(Side.CLIENT)
    public BlockRenderLayer func_180664_k()
    {
        return BlockRenderLayer.SOLID;
    }

    /**
     * @deprecated (Remove this as soon as minecraft offers anything better).
     */
    @Override
    @Deprecated
    public boolean func_149686_d(final IBlockState state)
    {
        return false;
    }

    @Override
    public boolean func_176205_b(final IBlockAccess worldIn, final BlockPos pos)
    {
        return true;
    }

    /**
     * @deprecated (Remove this as soon as minecraft offers anything better).
     */
    @Override
    @Deprecated
    public AxisAlignedBB func_185496_a(final IBlockState state, final IBlockAccess source, final BlockPos pos)
    {
        if (state.func_177229_b(FACING).equals(NORTH))
        {
            return new AxisAlignedBB((float) N_START_COLLISION_X,
                                      (float) BOTTOM_COLLISION,
                                      (float) N_START_COLLISION_Z,
                                      (float) N_END_COLLISION_X,
                                      (float) HEIGHT_COLLISION,
                                      (float) N_END_COLLISION_Z);
        }
        if (state.func_177229_b(FACING).equals(WEST))
        {
            return new AxisAlignedBB((float) W_START_COLLISION_X,
                                      (float) BOTTOM_COLLISION,
                                      (float) W_START_COLLISION_Z,
                                      (float) W_END_COLLISION_X,
                                      (float) HEIGHT_COLLISION,
                                      (float) W_END_COLLISION_Z);
        }
        if (state.func_177229_b(FACING).equals(SOUTH))
        {
            return new AxisAlignedBB((float) S_START_COLLISION_X,
                                      (float) BOTTOM_COLLISION,
                                      (float) S_START_COLLISION_Z,
                                      (float) S_END_COLLISION_X,
                                      (float) HEIGHT_COLLISION,
                                      (float) S_END_COLLISION_Z);
        }
        else
        {
            return new AxisAlignedBB((float) E_START_COLLISION_X,
                                      (float) BOTTOM_COLLISION,
                                      (float) E_START_COLLISION_Z,
                                      (float) E_END_COLLISION_X,
                                      (float) HEIGHT_COLLISION,
                                      (float) E_END_COLLISION_Z);
        }
    }

    // =======================================================================
    // ======================= Rendering & IBlockState =======================
    // =======================================================================
    @Override
    public IBlockState func_180642_a(
            final World worldIn,
            final BlockPos pos,
            final EnumFacing facing,
            final float hitX,
            final float hitY,
            final float hitZ,
            final int meta,
            @Nullable final EntityLivingBase placer)
    {
        @NotNull final EnumFacing enumFacing = (placer == null) ? NORTH : EnumFacing.func_176733_a(placer.field_70177_z);
        return this.func_176223_P().func_177226_a(FACING, enumFacing);
    }
}
