package com.minecolonies.coremod.client.render;

import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.EntityFishHook;
import com.minecolonies.coremod.lib.Literals;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

/**
 * Determines how the fish hook is rendered.
 */
public class RenderFishHook extends Render<EntityFishHook>
{
    /**
     * The resource location containing the particle textures (Spawned by the fishHook).
     */
    private static final ResourceLocation texture = new ResourceLocation("textures/particle/particles.png");

    /**
     * Required constructor, sets the RenderManager.
     *
     * @param renderManagerIn RenderManager that we use.
     */
    public RenderFishHook(final RenderManager renderManagerIn)
    {
        super(renderManagerIn);
    }

    /**
     * Render a fishing hook entity in the world
     * This class uses some GL11 stuff
     * and seems hard to document...
     *
     * @param entity    the hook to render
     * @param x         the x position
     * @param y         the y position
     * @param z         the z position
     * @param entityYaw the angle thrown
     */
    @Override
    public void func_76986_a(@NotNull final EntityFishHook entity, final double x, final double y, final double z, final float entityYaw, final float partialTicks)
    {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float) x, (float) y, (float) z);
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a(0.5F, 0.5F, 0.5F);
        this.func_180548_c(entity);
        final Tessellator tessellator = Tessellator.func_178181_a();
        final VertexBuffer vertexBuffer = tessellator.func_178180_c();

        GlStateManager.func_179114_b((float) (180.0D - this.field_76990_c.field_78735_i), 0.0F, 1.0F, 0.0F);
        GlStateManager.func_179114_b(-this.field_76990_c.field_78732_j, 1.0F, 0.0F, 0.0F);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        vertexBuffer.func_181662_b(-0.5D, -0.5D, 0.0D).func_187315_a(0.0625D, 0.1875D).func_181663_c(0.0F, 1.0F, 0.0F).func_181675_d();
        vertexBuffer.func_181662_b(0.5D, -0.5D, 0.0D).func_187315_a(0.125D, 0.1875D).func_181663_c(0.0F, 1.0F, 0.0F).func_181675_d();
        vertexBuffer.func_181662_b(0.5D, 0.5D, 0.0D).func_187315_a(0.125D, 0.125D).func_181663_c(0.0F, 1.0F, 0.0F).func_181675_d();
        vertexBuffer.func_181662_b(-0.5D, 0.5D, 0.0D).func_187315_a(0.0625D, 0.125D).func_181663_c(0.0F, 1.0F, 0.0F).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();

        EntityCitizen citizen = entity.getCitizen();

        //If the citizen is null (Which he probably is) get the nearest citizen to the fishHook position.
        //Check if he is a fisherman -> Through his texture
        if (citizen == null)
        {
            for (@NotNull final Object citizenX : entity.field_70170_p.func_72872_a(EntityCitizen.class, entity.func_174813_aQ().func_72314_b(10, 10, 10)))
            {
                if (((EntityCitizen) citizenX).getModelID().textureBase.contains("Fisherman"))
                {
                    citizen = (EntityCitizen) citizenX;
                    break;
                }
            }
        }

        if (citizen != null)
        {
            final double orientation = citizen.func_70678_g(partialTicks);
            final double finalOrientation = Math.sin(Math.sqrt(orientation) * Math.PI);
            @NotNull final Vec3d Vec3d = new Vec3d(-0.36D, 0.03D, 0.35D);

            Vec3d.func_178789_a((float) (-((double) citizen.field_70127_C + ((double) citizen.field_70125_A - (double) citizen.field_70127_C) * partialTicks)
                                         * Math.PI / Literals.HALF_CIRCLE));
            Vec3d.func_178785_b((float) (-((double) citizen.field_70126_B + ((double) citizen.field_70177_z - (double) citizen.field_70126_B)
                                                                            * partialTicks) * Math.PI / Literals.HALF_CIRCLE));
            Vec3d.func_178785_b((float) (finalOrientation * 0.5D));
            Vec3d.func_178789_a((float) (-finalOrientation * 0.7D));

            final double thirdPersonOffset = (citizen.field_70760_ar + ((double) citizen.field_70761_aq - citizen.field_70760_ar) * partialTicks)
                                               * Math.PI / Literals.HALF_CIRCLE;
            final double correctedPosX = citizen.field_70169_q + (citizen.field_70165_t - citizen.field_70169_q) * (double) partialTicks - MathHelper.func_76134_b((float) thirdPersonOffset) * 0.35D
                                           - MathHelper.func_76126_a((float) thirdPersonOffset) * 0.8D;
            final double correctedPosY = citizen.field_70167_r + citizen.func_70047_e() + (citizen.field_70163_u - citizen.field_70167_r) * (double) partialTicks - 0.45D;
            final double correctedPosZ = citizen.field_70166_s + (citizen.field_70161_v - citizen.field_70166_s) * (double) partialTicks - MathHelper.func_76126_a((float) thirdPersonOffset) * 0.35D
                                           + MathHelper.func_76134_b((float) thirdPersonOffset) * 0.8D;
            final double eyeHeight = citizen.func_70093_af() ? -0.1875D : 0.0D;

            final double distX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * partialTicks;
            final double distY = entity.field_70163_u + 0.25;
            final double distZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * partialTicks;

            final double correctionX = correctedPosX - distX;
            final double correctionY = correctedPosY - distY + eyeHeight;
            final double correctionZ = correctedPosZ - distZ;

            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            vertexBuffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);

            for (int l = 0; l <= 16; ++l)
            {
                final double var = (double) l / 16.0;
                vertexBuffer.func_181662_b(x + correctionX * var, y + correctionY * (var * var + var) * 0.5D + 0.25D, z + correctionZ * var).func_181669_b(0, 0, 0, 255).func_181675_d();
            }

            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    /**
     * Returns the location of an entity's texture. Doesn't seem to be called unless you call Render.bindEntityTexture.
     *
     * @param entity the entity to get the texture from
     * @return a resource location for the texture
     */
    @NotNull
    @Override
    protected ResourceLocation func_110775_a(final EntityFishHook entity)
    {
        return getTexture();
    }

    /**
     * Returns the location of an entity's texture.
     *
     * @return the address of the resource
     */
    @NotNull
    private static ResourceLocation getTexture()
    {
        return texture;
    }
}
