package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.coremod.entity.EntityCitizen;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

/**
 * Entity action to wander randomly around.
 */
public class EntityAICitizenWander extends EntityAIBase
{
    private final EntityCitizen citizen;
    private       double        xPosition;
    private       double        yPosition;
    private       double        zPosition;
    private final double        speed;

    /**
     * Instantiates this task.
     *
     * @param citizen the citizen.
     * @param speed   the speed.
     */
    public EntityAICitizenWander(final EntityCitizen citizen, final double speed)
    {
        super();
        this.citizen = citizen;
        this.speed = speed;
        this.func_75248_a(1);
    }

    /**
     * {@inheritDoc}
     * Returns whether the EntityAIBase should begin execution.
     * True when age less than 100, when a random (120) is chosen correctly, and when a citizen is nearby.
     */
    @Override
    public boolean func_75250_a()
    {
        if (isToOld() || checkForRandom() || citizen.getDesiredActivity() == EntityCitizen.DesiredActivity.SLEEP)
        {
            return false;
        }
        Vec3d Vec3d = RandomPositionGenerator.func_75463_a(citizen, 10, 7);
        if (Vec3d == null)
        {
            return false;
        }

        Vec3d = new Vec3d(Vec3d.field_72450_a, getValidHeight(Vec3d), Vec3d.field_72449_c);

        this.xPosition = Vec3d.field_72450_a;
        this.yPosition = Vec3d.field_72448_b;
        this.zPosition = Vec3d.field_72449_c;

        return true;
    }

    /**
     * Returns whether or not the citizen is too old to wander.
     * True when age >= 100.
     *
     * @return True when age => 100, otherwise false.
     */
    private boolean isToOld()
    {
        return citizen.func_70654_ax() >= 100;
    }

    private boolean checkForRandom()
    {
        return citizen.func_70681_au().nextInt(120) != 0;
    }

    /**
     * Returns the right height for the given position (ground block).
     *
     * @param position Current position of the entity.
     * @return Ground level at (position.x, position.z).
     */
    private double getValidHeight(@NotNull final Vec3d position)
    {
        double returnHeight = position.field_72448_b;
        if (position.field_72448_b < 0)
        {
            returnHeight = 0;
        }

        while (returnHeight >= 1 && citizen.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c(position.field_72450_a),
                                                                              (int) returnHeight,
                                                                              MathHelper.func_76128_c(position.field_72449_c))))
        {
            returnHeight -= 1.0D;
        }

        while (!citizen.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c(position.field_72450_a), (int) returnHeight, MathHelper.func_76128_c(position.field_72449_c))))
        {
            returnHeight += 1.0D;
        }
        return returnHeight;
    }

    /**
     * {@inheritDoc}
     * Returns whether an in-progress EntityAIBase should continue executing.
     */
    @Override
    public boolean func_75253_b()
    {
        return !citizen.func_70661_as().func_75500_f();
    }

    /**
     * {@inheritDoc}
     * Execute a one shot task or start executing a continuous task.
     */
    @Override
    public void func_75249_e()
    {
        citizen.func_70661_as().func_75492_a(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }
}
