package com.minecolonies.coremod.items;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

/**
 * Class handling the buildTool item.
 */
public class ItemBuildTool extends AbstractItemMinecolonies
{
    /**
     * Instantiates the buildTool on load.
     */
    public ItemBuildTool()
    {
        super("scepterGold");

        super.func_77637_a(ModCreativeTabs.MINECOLONIES);
        func_77625_d(1);
    }

    @NotNull
    @Override
    public EnumActionResult func_180614_a(
                                       final ItemStack stack,
                                       final EntityPlayer playerIn,
                                       final World worldIn,
                                       final BlockPos pos,
                                       final EnumHand hand,
                                       final EnumFacing facing,
                                       final float hitX,
                                       final float hitY,
                                       final float hitZ)
    {
        playerIn.func_71029_a(ModAchievements.achievementWandOfbuilding);
        if (worldIn.field_72995_K)
        {
            MineColonies.proxy.openBuildToolWindow(pos.func_177972_a(facing));
        }

        return EnumActionResult.SUCCESS;
    }

    @NotNull
    @Override
    public ActionResult<ItemStack> func_77659_a(@NotNull final ItemStack itemStackIn, final World worldIn, final EntityPlayer playerIn, final EnumHand hand)
    {
        if (worldIn.field_72995_K)
        {
            MineColonies.proxy.openBuildToolWindow(null);
        }

        return new ActionResult<>(EnumActionResult.SUCCESS, itemStackIn);
    }
}
