package com.minecolonies.coremod.items;

import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

/**
 * Caliper Item class. Calculates distances, areas, and volumes.
 */
public class ItemCaliper extends AbstractItemMinecolonies
{
    private static final RangedAttribute ATTRIBUTE_CALIPER_USE = new RangedAttribute((IAttribute) null, "player.caliperUse", 0.0, 0.0, 1.0);

    private static final double HALF                        = 0.5;
    private static final String ITEM_CALIPER_MESSAGE_LINE   = "item.caliper.message.line";
    private static final String ITEM_CALIPER_MESSAGE_SQUARE = "item.caliper.message.square";
    private static final String ITEM_CALIPER_MESSAGE_CUBE   = "item.caliper.message.cube";
    private static final String ITEM_CALIPER_MESSAGE_SAME   = "item.caliper.message.same";

    private BlockPos startPosition;

    /**
     * Caliper constructor. Sets max stack to 1, like other tools.
     */
    public ItemCaliper()
    {
        super("caliper");

        super.func_77637_a(ModCreativeTabs.MINECOLONIES);
        field_77777_bU = 1;
    }

    private static EnumActionResult handleZEqual(@NotNull final EntityPlayer playerIn, final int a, final int a2)
    {
        final int distance1 = Math.abs(a) + 1;
        final int distance2 = Math.abs(a2) + 1;

        LanguageHandler.sendPlayerMessage(
                playerIn, ITEM_CALIPER_MESSAGE_SQUARE, Integer.toString(distance1), Integer.toString(distance2));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult func_180614_a(
                                       final ItemStack stack,
                                       final EntityPlayer playerIn,
                                       final World worldIn,
                                       final BlockPos pos,
                                       final EnumHand hand,
                                       final EnumFacing facing,
                                       final float hitX,
                                       final float hitY,
                                       final float hitZ)
    {
        // if client world, do nothing
        if (worldIn.field_72995_K)
        {
            return EnumActionResult.FAIL;
        }

        // if attribute instance is not known, register it.
        IAttributeInstance attribute = playerIn.func_110148_a(ATTRIBUTE_CALIPER_USE);
        if (attribute == null)
        {
            attribute = playerIn.func_110140_aT().func_111150_b(ATTRIBUTE_CALIPER_USE);
        }
        // if the value of the attribute is still 0, set the start values. (first point)
        if (attribute.func_111126_e() < HALF)
        {
            startPosition = pos;
            attribute.func_111128_a(1.0);
            return EnumActionResult.SUCCESS;
        }
        attribute.func_111128_a(0.0);
        //Start == end, same location
        if (startPosition.func_177958_n() == pos.func_177958_n() && startPosition.func_177956_o() == pos.func_177956_o() && startPosition.func_177952_p() == pos.func_177952_p())
        {
            LanguageHandler.sendPlayerMessage(playerIn, ITEM_CALIPER_MESSAGE_SAME);
            return EnumActionResult.FAIL;
        }

        return handlePlayerMessage(playerIn, pos);
    }

    private EnumActionResult handlePlayerMessage(@NotNull final EntityPlayer playerIn, @NotNull final BlockPos pos)
    {
        if (startPosition.func_177958_n() == pos.func_177958_n())
        {
            return handleXEqual(playerIn, pos);
        }
        if (startPosition.func_177956_o() == pos.func_177956_o())
        {
            return handleYEqual(playerIn, pos, pos.func_177958_n() - startPosition.func_177958_n(), pos.func_177956_o() - startPosition.func_177952_p());
        }
        if (startPosition.func_177952_p() == pos.func_177952_p())
        {
            return handleZEqual(playerIn, pos.func_177958_n() - startPosition.func_177958_n(), pos.func_177956_o() - startPosition.func_177956_o());
        }

        final int distance1 = Math.abs(pos.func_177958_n() - startPosition.func_177958_n()) + 1;
        final int distance2 = Math.abs(pos.func_177956_o() - startPosition.func_177956_o()) + 1;
        final int distance3 = Math.abs(pos.func_177952_p() - startPosition.func_177952_p()) + 1;

        LanguageHandler.sendPlayerMessage(
                playerIn,
                ITEM_CALIPER_MESSAGE_CUBE,
                Integer.toString(distance1), Integer.toString(distance2), Integer.toString(distance3));
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult handleYEqual(@NotNull final EntityPlayer playerIn, @NotNull final BlockPos pos, final int a, final int a2)
    {
        if (startPosition.func_177952_p() == pos.func_177952_p())
        {
            final int distance = Math.abs(a) + 1;
            LanguageHandler.sendPlayerMessage(playerIn, ITEM_CALIPER_MESSAGE_LINE, Integer.toString(distance));
            return EnumActionResult.SUCCESS;
        }
        return handleZEqual(playerIn, a, a2);
    }

    private EnumActionResult handleXEqual(@NotNull final EntityPlayer playerIn, @NotNull final BlockPos pos)
    {
        if (startPosition.func_177956_o() == pos.func_177956_o())
        {
            final int distance = Math.abs(pos.func_177952_p() - startPosition.func_177952_p()) + 1;
            LanguageHandler.sendPlayerMessage(playerIn, ITEM_CALIPER_MESSAGE_LINE, Integer.toString(distance));
            return EnumActionResult.SUCCESS;
        }
        return handleYEqual(playerIn, pos, pos.func_177956_o() - startPosition.func_177956_o(), pos.func_177952_p() - startPosition.func_177952_p());
    }
}
