package com.minecolonies.coremod.items;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.lib.Constants;
import com.minecolonies.coremod.network.messages.SaveScanMessage;
import com.minecolonies.coremod.util.BlockPosUtil;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Item used to scan structures. Will store the structure on the client even if used in smp.
 */
public class ItemScanTool extends AbstractItemMinecolonies
{
    /**
     * Creates instance of item.
     */
    public ItemScanTool()
    {
        super("scepterSteel");

        super.func_77637_a(ModCreativeTabs.MINECOLONIES);
        func_77625_d(1);
    }

    @NotNull
    @Override
    public EnumActionResult func_180614_a(
                                       final ItemStack stack,
                                       final EntityPlayer playerIn,
                                       final World worldIn,
                                       final BlockPos pos,
                                       final EnumHand hand,
                                       final EnumFacing facing,
                                       final float hitX,
                                       final float hitY,
                                       final float hitZ)
    {
        if (!stack.func_77942_o())
        {
            stack.func_77982_d(new NBTTagCompound());
        }
        final NBTTagCompound compound = stack.func_77978_p();

        if (!compound.func_74764_b("pos1"))
        {
            BlockPosUtil.writeToNBT(compound, "pos1", pos);
            if (worldIn.field_72995_K)
            {
                LanguageHandler.sendPlayerMessage(playerIn, "item.scepterSteel.point");
            }
            return EnumActionResult.SUCCESS;
        }
        else if (!compound.func_74764_b("pos2"))
        {
            @NotNull final BlockPos pos1 = BlockPosUtil.readFromNBT(compound, "pos1");
            @NotNull final BlockPos pos2 = pos;
            if (pos2.func_177951_i(pos1) > 0)
            {
                BlockPosUtil.writeToNBT(compound, "pos2", pos2);
                if (worldIn.field_72995_K)
                {
                    LanguageHandler.sendPlayerMessage(playerIn, "item.scepterSteel.point2");
                }
                return EnumActionResult.SUCCESS;
            }
            if (worldIn.field_72995_K)
            {
                LanguageHandler.sendPlayerMessage(playerIn, "item.scepterSteel.samePoint");
            }
            return EnumActionResult.FAIL;
        }
        else
        {
            @NotNull final BlockPos pos1 = BlockPosUtil.readFromNBT(compound, "pos1");
            @NotNull final BlockPos pos2 = BlockPosUtil.readFromNBT(compound, "pos2");
            if (!worldIn.field_72995_K)
            {
                saveStructure(worldIn, pos1, pos2, playerIn);
            }
            compound.func_82580_o("pos1");
            compound.func_82580_o("pos2");
            return EnumActionResult.SUCCESS;
        }
    }

    /**
     * Scan the structure and save it to the disk.
     *
     * @param world  Current world.
     * @param from   First corner.
     * @param to     Second corner.
     * @param player causing this action.
     */
    private static void saveStructure(@Nullable final World world, @Nullable final BlockPos from, @Nullable final BlockPos to, @NotNull final EntityPlayer player)
    {
        if (world == null || from == null || to == null)
        {
            throw new IllegalArgumentException("Invalid method call, arguments can't be null. Contact a developer.");
        }

        final BlockPos blockpos =
          new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()));
        final BlockPos blockpos1 =
          new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
        final BlockPos size = blockpos1.func_177973_b(blockpos).func_177982_a(1, 1, 1);

        final WorldServer worldserver = (WorldServer) world;
        final MinecraftServer minecraftserver = world.func_73046_m();
        final TemplateManager templatemanager = worldserver.func_184163_y();

        final String currentMillis = Long.toString(System.currentTimeMillis());
        final String fileName = "/minecolonies/scans/" + LanguageHandler.format("item.scepterSteel.scanFormat", "", currentMillis + ".nbt");

        final Template template = templatemanager.func_186237_a(minecraftserver, new ResourceLocation(fileName));
        template.func_186254_a(world, blockpos, size, true, Blocks.field_189881_dj);
        template.func_186252_a(Constants.MOD_ID);

        MineColonies.getNetwork().sendTo(new SaveScanMessage(template.func_189552_a(new NBTTagCompound()), currentMillis), (EntityPlayerMP) player);
    }
}
