package com.minecolonies.coremod.util;

import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Client only structure wrapper methods.
 */
public final class ClientStructureWrapper
{
    /**
     * Private constructor to hide implicit one.
     */
    private ClientStructureWrapper()
    {
        /*
         * Intentionally left empty
         */
    }

    /**
     * Handles the save message of scans.
     *
     * @param nbttagcompound compound to store.
     * @param currentMillis  the current milliseconds.
     */
    public static void handleSaveScanMessage(final NBTTagCompound nbttagcompound, final String currentMillis)
    {
        final String fileName = "/minecolonies/scans/" + LanguageHandler.format("item.scepterSteel.scanFormat", currentMillis, ".nbt");

        final File file = new File(Minecraft.func_71410_x().field_71412_D, fileName);
        createScanDirectory(Minecraft.func_71410_x().field_71441_e);

        try (OutputStream outputstream = new FileOutputStream(file))
        {
            CompressedStreamTools.func_74799_a(nbttagcompound, outputstream);
        }
        catch (final IOException e)
        {
            LanguageHandler.sendPlayerMessage(Minecraft.func_71410_x().field_71439_g, "item.scepterSteel.scanFailure");
            Log.getLogger().warn("Exception while trying to scan.", e);
            return;
        }

        LanguageHandler.sendPlayerMessage(Minecraft.func_71410_x().field_71439_g,"item.scepterSteel.scanSuccess", fileName);
    }

    /**
     * Creates the scan directories for the scanTool.
     *
     * @param world the worldIn.
     */
    private static void createScanDirectory(@NotNull final World world)
    {
        final File minecolonies;
        if (world.field_72995_K)
        {
            minecolonies = new File(Minecraft.func_71410_x().field_71412_D, "minecolonies/");
        }
        else
        {
            final MinecraftServer server = world.func_73046_m();
            if (server == null)
            {
                return;
            }
            minecolonies = server.func_71209_f("minecolonies/");
        }
        checkDirectory(minecolonies);

        @NotNull final File scans = new File(minecolonies, "scans/");
        checkDirectory(scans);
    }

    /**
     * Checks if directory exists, else creates it.
     *
     * @param directory the directory to check.
     */
    private static void checkDirectory(@NotNull final File directory)
    {
        if (!directory.exists() && !directory.mkdirs())
        {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }
}
