package com.minecolonies.structures.event;

import com.minecolonies.coremod.util.BlockUtils;
import com.minecolonies.structures.helpers.Settings;
import com.minecolonies.structures.helpers.Structure;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

/**
 * EventHandler used to display the schematics on the client.
 */
public class RenderEventHandler
{

    /**
     * Event used to render the schematics. Only render the schematic if there is one in the settings.
     *
     * @param event Object containing event details.
     */
    @SubscribeEvent
    public void onRenderWorldLast(final RenderWorldLastEvent event)
    {
        final Structure structure = Settings.instance.getActiveStructure();
        if (structure != null)
        {
            BlockPos size = structure.getSize(BlockUtils.getRotation(Settings.instance.getRotation()));
            BlockPos position = Settings.instance.pos;

            final int x = size.func_177958_n();
            final int z = size.func_177952_p();
            final int y = size.func_177956_o();

            if (Settings.instance.getRotation() == 1)
            {
                size = new BlockPos(-x, y, z);
            }
            if (Settings.instance.getRotation() == 2)
            {
                size = new BlockPos(-x, y, -z);
            }
            if (Settings.instance.getRotation() == 3)
            {
                size = new BlockPos(x, y, -z);
            }

            final BlockPos offset = Settings.instance.getOffset(
                    new PlacementSettings().func_186220_a(BlockUtils.getRotation(Settings.instance.getRotation())).func_186214_a(Settings.instance.getMirror()));

            if (offset.equals(new BlockPos(0, 0, 0)))
            {
                position = position.func_177973_b(new BlockPos(size.func_177958_n() / 2, 0, size.func_177952_p() / 2));
            }
            else
            {
                position = position.func_177973_b(offset);
            }
            structure.renderStructure(position, Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g, event.getPartialTicks());
        }
    }
}
