package com.minecolonies.blockout;

import com.minecolonies.blockout.views.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Keyboard;

/**
 * Wraps MineCrafts GuiScreen for BlockOut's Window.
 */
public class Screen extends GuiScreen
{
    protected static int scale = 0;
    protected Window window;
    protected int x = 0;
    protected int y = 0;

    /**
     * Create a GuiScreen from a BlockOut window.
     *
     * @param w blockout window.
     */
    public Screen(final Window w)
    {
        super();
        window = w;
    }

    public static int getScale()
    {
        return scale;
    }

    private static void setScale(final Minecraft mc)
    {
        //Seems to work without the sides now
        scale = new ScaledResolution(mc).func_78325_e();
    }

    @Override
    public void func_73863_a(final int mx, final int my, final float f)
    {
        if (window.hasLightbox())
        {
            super.func_146276_q_();
        }

        setScale(field_146297_k);

        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(x, y, 0);
        window.draw(mx - x, my - y);
        GlStateManager.func_179121_F();
    }

    @Override
    protected void func_73869_a(final char ch, final int key)
    {
        window.onKeyTyped(ch, key);
    }

    @Override
    protected void func_73864_a(final int mx, final int my, final int code)
    {
        if (code == 0)
        {
            //  Adjust coordinate to origin of window
            window.click(mx - x, my - y);
        }
    }

    @Override
    protected void func_146286_b(final int mx, final int my, final int code)
    {
        if (code == 0)
        {
            //  Adjust coordinate to origin of window
            window.onMouseReleased(mx - x, my - y);
        }
    }

    @Override
    protected void func_146273_a(final int mx, final int my, final int buttons, final long timeElapsed)
    {
        // Can be overridden
    }

    @Override
    public void func_73866_w_()
    {
        x = (field_146294_l - window.getWidth()) / 2;
        y = (field_146295_m - window.getHeight()) / 2;

        Keyboard.enableRepeatEvents(true);
        window.onOpened();
    }

    @Override
    public void func_73876_c()
    {
        window.onUpdate();

        if (!field_146297_k.field_71439_g.func_70089_S() || field_146297_k.field_71439_g.field_70128_L)
        {
            field_146297_k.field_71439_g.func_71053_j();
        }
    }

    @Override
    public void func_146281_b()
    {
        window.onClosed();
        Window.clearFocus();
        Keyboard.enableRepeatEvents(false);
    }

    @Override
    public boolean func_73868_f()
    {
        return window.doesWindowPauseGame();
    }
}
