package com.minecolonies.coremod.blocks;

import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.lib.Constants;
import com.minecolonies.coremod.util.Log;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Random;

public class BlockBarrel extends Block
{
    private static final int MIN_FULLNESS           = 0;
    private static final int MAX_FULLNESS           = 16;
    private static final int BARRELSTATE_FILLING    = 0;
    private static final int BARRELSTATE_COMPOSTING = 1;
    private static final int BARRELSTATE_DONE       = 2;

    // todo: use a TileEntity to store state

    private static final PropertyInteger            BARRELSTATE    = PropertyInteger.func_177719_a("BARRELSTATE", BARRELSTATE_FILLING, BARRELSTATE_DONE);
    /**
     * The hardness this block has.
     */
    private static final float                      BLOCK_HARDNESS = 5F;
    /**
     * This blocks name.
     */
    private static final String                     BLOCK_NAME     = "blockBarrel";
    /**
     * The resistance this block has.
     */
    private static final float                      RESISTANCE     = 1F;
    private static final HashMap<BlockPos, Integer> timers         = new HashMap<>();
    private static final HashMap<BlockPos, Integer> fillings       = new HashMap<>();

    public BlockBarrel()
    {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BARRELSTATE, BARRELSTATE_FILLING));

        this.func_149675_a(true);
        initBlock();
    }

    //todo: register block with new method
    @SuppressWarnings("deprecation")
    /**
     * initialize the block
     */
    private void initBlock()
    {
        setRegistryName(BLOCK_NAME);
        func_149663_c(String.format("%s.%s", Constants.MOD_ID.toLowerCase(), BLOCK_NAME));
        func_149647_a(ModCreativeTabs.MINECOLONIES);
        GameRegistry.registerBlock(this, BLOCK_NAME);
        func_149711_c(BLOCK_HARDNESS);
        func_149752_b(RESISTANCE);
    }

    public void AddItemToBarrel(final World worldIn, final EntityPlayer playerIn, final ItemStack itemStack, final IBlockState state, final BlockPos pos)
    {
        UseBarrel(worldIn, playerIn, itemStack, state, pos);
    }

    //whenever player right click to barrel call this.
    public boolean UseBarrel(final World worldIn, final EntityPlayer playerIn, final ItemStack itemstack, final IBlockState state, final BlockPos pos)
    {
        Log.getLogger().info("block activated");

        final int barrelState = state.func_177229_b(BARRELSTATE);
        int fullness = fillings.getOrDefault(pos, 0);

        Log.getLogger().info("At this moment bs= " + barrelState + " and fl=" + fullness);


        //if statement 1
        if (state.func_177229_b(BARRELSTATE) == BARRELSTATE_DONE)
        {
            // todo: add this back in once compost exists again
            // playerIn.inventory.addItemStackToInventory(new ItemStack(ModItems.compost, 8));
            worldIn.func_175656_a(pos, state.func_177226_a(BARRELSTATE, BARRELSTATE_FILLING));
            fillings.put(pos, MIN_FULLNESS);
            Log.getLogger().info("Set Blockstate to " + worldIn.func_180495_p(pos));
            return true;
        }

        if (itemstack == null)
        {
            return true;
        }

        final Item item = itemstack.func_77973_b();

        if (item == Items.field_151078_bh && barrelState == BARRELSTATE_FILLING)
        {
            Log.getLogger().info("item Consumed");

            itemstack.field_77994_a--;

            fullness += 1;
            if (fullness >= MAX_FULLNESS)
            {
                fullness = MAX_FULLNESS;
                worldIn.func_175656_a(pos, state.func_177226_a(BARRELSTATE, BARRELSTATE_COMPOSTING));
            }
            fillings.put(pos, fullness);
            Log.getLogger().info("now FULLNESS = " + fullness);

            return true;
        }

        return true;
    }

    public void GetItemFromBarrel(final World worldIn, final EntityPlayer playerIn, final ItemStack itemStack, final IBlockState state, final BlockPos pos)
    {
        final int bs = state.func_177229_b(BARRELSTATE);
        if (bs == 2)
        {
            UseBarrel(worldIn, playerIn, null, state, pos);
        }
    }

    //todo: remove once we no longer need to support this
    @SuppressWarnings("deprecation")
    @Override
    public IBlockState func_176203_a(final int meta)
    {
        return this.func_176223_P().func_177226_a(BARRELSTATE, meta);
    }

    @Override
    public int func_176201_c(final IBlockState state)
    {
        return state.func_177229_b(BARRELSTATE);
    }

    /**
     * Used to determine ambient occlusion and culling when rebuilding chunks for render.
     *
     * @return true
     */
    //todo: remove once we no longer need to support this
    @SuppressWarnings("deprecation")
    @Override
    public boolean func_149662_c(final IBlockState state)
    {
        return true;
    }

    @Override
    public void func_180650_b(final World worldIn, final BlockPos pos, final IBlockState state, final Random rand)
    {
        Log.getLogger().info("UpdateTick called");

        final int barrelState = state.func_177229_b(BARRELSTATE);

        Log.getLogger().info("now BARRELSTATE = " + barrelState);
        switch (state.func_177229_b(BARRELSTATE))
        {
            case BARRELSTATE_FILLING:
                checkIfBarrelFull(worldIn, pos, state);
                break;
            case BARRELSTATE_COMPOSTING:
                doBarrelCompostTick(worldIn, pos, state);
                break;
            case BARRELSTATE_DONE:
                break;
        }
    }

    private static void checkIfBarrelFull(final World world, final BlockPos pos, final IBlockState state)
    {
        final int fullness = fillings.getOrDefault(pos, 0);
        if (fullness >= MAX_FULLNESS)
        {
            Log.getLogger().info("Barrel is full.");
            world.func_175656_a(pos, state.func_177226_a(BARRELSTATE, BARRELSTATE_COMPOSTING));
        }
    }

    private static void doBarrelCompostTick(final World world, final BlockPos pos, final IBlockState state)
    {
        int timer = timers.getOrDefault(pos, 0);
        timer++;
        if (timer >= 20)
        {
            world.func_175656_a(pos, state.func_177226_a(BARRELSTATE, BARRELSTATE_DONE));
            timer = 0;
        }
        timers.put(pos, timer);
    }

    @NotNull
    @Override
    protected BlockStateContainer func_180661_e()
    {
        return new BlockStateContainer(this, BARRELSTATE);
    }

    public boolean onBlockActivated(
                                     final World worldIn,
                                     final BlockPos pos,
                                     final IBlockState state,
                                     final EntityPlayer playerIn,
                                     final EnumFacing side,
                                     final float hitX,
                                     final float hitY,
                                     final float hitZ)
    {
        Log.getLogger().info("block right-clicked");

        final ItemStack itemstack = playerIn.field_71071_by.func_70448_g();
        UseBarrel(worldIn, playerIn, itemstack, state, pos);
        return true;
    }
}
