package com.minecolonies.coremod.blocks;

import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.inventory.InventoryField;
import com.minecolonies.coremod.lib.Constants;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.util.LanguageHandler;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static net.minecraft.util.EnumFacing.NORTH;
import static net.minecraft.util.EnumFacing.fromAngle;

/**
 * The class handling the fieldBlocks, placement and activation.
 */
public class BlockHutField extends BlockContainer
{
    /**
     * The position it faces.
     */
    public static final  PropertyDirection FACING           = BlockHorizontal.field_185512_D;
    /**
     * Hardness of the block.
     */
    private static final float             HARDNESS         = 10F;
    /**
     * Resistance of the block.
     */
    private static final float             RESISTANCE       = 10F;
    /**
     * Start of the collision box at y.
     */
    private static final double            BOTTOM_COLLISION = 0.0;

    /**
     * Start of the collision box at x and z.
     */
    private static final double START_COLLISION = 0.1;

    /**
     * End of the collision box.
     */
    private static final double END_COLLISION = 0.9;

    /**
     * Height of the collision box.
     */
    private static final double HEIGHT_COLLISION = 2.5;

    /**
     * Registry name for this block.
     */
    private static final String REGISTRY_NAME = "blockHutField";

    /**
     * Constructor called on block placement.
     */
    BlockHutField()
    {
        super(Material.field_151575_d);
        initBlock();
    }

    /**
     * Method called by constructor.
     * Sets basic details of the block.
     */
    private void initBlock()
    {
        setRegistryName(REGISTRY_NAME);
        func_149663_c(Constants.MOD_ID.toLowerCase() + "." + "blockHutField");
        func_149647_a(ModCreativeTabs.MINECOLONIES);
        //Blast resistance for creepers etc. makes them explosion proof.
        func_149752_b(RESISTANCE);
        //Hardness of 10 takes a long time to mine to not loose progress.
        func_149711_c(HARDNESS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, NORTH));
        GameRegistry.register(this);
        GameRegistry.register((new ItemBlock(this)).setRegistryName(this.getRegistryName()));
    }

    @Override
    public EnumBlockRenderType func_149645_b(final IBlockState state)
    {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public int func_176201_c(@NotNull final IBlockState state)
    {
        return state.func_177229_b(FACING).func_176745_a();
    }

    //todo: remove once we no longer need to support this
    @SuppressWarnings("deprecation")
    @Override
    public boolean func_149686_d(final IBlockState state)
    {
        return false;
    }

    @Override
    public boolean func_176205_b(final IBlockAccess worldIn, final BlockPos pos)
    {
        return false;
    }

    //todo: remove once we no longer need to support this
    @SuppressWarnings("deprecation")
    @Override
    public AxisAlignedBB func_185496_a(final IBlockState state, final IBlockAccess source, final BlockPos pos)
    {
        return new AxisAlignedBB((float) START_COLLISION,
                                  (float) BOTTOM_COLLISION,
                                  (float) START_COLLISION,
                                  (float) END_COLLISION,
                                  (float) HEIGHT_COLLISION,
                                  (float) END_COLLISION);
    }

    //todo: remove once we no longer need to support this
    @SuppressWarnings("deprecation")
    @Override
    public boolean func_149662_c(final IBlockState state)
    {
        return false;
    }

    @NotNull
    @Override
    @SideOnly(Side.CLIENT)
    public BlockRenderLayer func_180664_k()
    {
        return BlockRenderLayer.SOLID;
    }

    @Override
    public boolean func_180639_a(
                                     final World worldIn,
                                     final BlockPos pos,
                                     final IBlockState state,
                                     final EntityPlayer playerIn,
                                     final EnumHand hand,
                                     @Nullable final ItemStack heldItem,
                                     final EnumFacing side,
                                     final float hitX,
                                     final float hitY,
                                     final float hitZ)
    {
        //If the world is server, open the inventory of the field.
        if (!worldIn.field_72995_K)
        {
            @Nullable final Colony colony = ColonyManager.getColony(worldIn, pos);
            if (colony != null)
            {
                playerIn.openGui(MineColonies.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
        }
        return false;
    }

    // =======================================================================
    // ======================= Rendering & IBlockState =======================
    // =======================================================================
    @Override
    public IBlockState func_180642_a(
                                      final World worldIn,
                                      final BlockPos pos,
                                      final EnumFacing facing,
                                      final float hitX,
                                      final float hitY,
                                      final float hitZ,
                                      final int meta,
                                      @Nullable final EntityLivingBase placer)
    {
        @NotNull final EnumFacing enumFacing = (placer == null) ? NORTH : func_176733_a(placer.field_70177_z);
        return this.func_176223_P().func_177226_a(FACING, enumFacing);
    }

    @Override
    public void func_180633_a(@NotNull final World worldIn, @NotNull final BlockPos pos, final IBlockState state, final EntityLivingBase placer, final ItemStack stack)
    {
        //Only work on server side.
        if (worldIn.field_72995_K)
        {
            return;
        }

        if (placer instanceof EntityPlayer)
        {
            @Nullable final Colony colony = ColonyManager.getColony(worldIn, pos);

            if (colony != null)
            {
                @NotNull final InventoryField inventoryField = new InventoryField(LanguageHandler.format("com.minecolonies.coremod.gui.inventory.scarecrow"));

                ((ScarecrowTileEntity) worldIn.func_175625_s(pos)).setInventoryField(inventoryField);
                colony.addNewField((ScarecrowTileEntity) worldIn.func_175625_s(pos), ((EntityPlayer) placer).field_71071_by, pos, worldIn);
            }
        }
    }

    @NotNull
    @Override
    protected BlockStateContainer func_180661_e()
    {
        return new BlockStateContainer(this, FACING);
    }

    @Override
    public boolean hasTileEntity(final IBlockState state)
    {
        return true;
    }

    @NotNull
    @Override
    public TileEntity func_149915_a(final World worldIn, final int meta)
    {
        return new ScarecrowTileEntity();
    }
    // =======================================================================
    // ===================== END of Rendering & Meta-Data ====================
    // =======================================================================
}
