package com.minecolonies.coremod.client.model;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class ModelEntityCitizenFemaleCitizen extends ModelBiped
{
    ModelRenderer breast;
    ModelRenderer hair;
    ModelRenderer dressPart1;
    ModelRenderer dressPart2;
    ModelRenderer dressPart3;

    public ModelEntityCitizenFemaleCitizen()
    {

        field_78090_t = 64;
        field_78089_u = 64;

        field_78116_c = new ModelRenderer(this, 0, 0);
        field_78116_c.func_78789_a(-4F, -8F, -4F, 8, 8, 8);
        field_78116_c.func_78793_a(0F, 0F, 1F);
        field_78116_c.func_78787_b(64, 64);
        setRotation(field_78116_c, 0F, 0F, 0F);

        field_178720_f = new ModelRenderer(this, 32, 0);
        field_178720_f.func_78790_a(-4F, -8F, -4F, 8, 8, 8, 0.5F);
        field_178720_f.func_78793_a(0F, 0F, 1F);
        field_178720_f.func_78787_b(64, 64);
        setRotation(field_178720_f, 0F, 0F, 0F);

        field_78115_e = new ModelRenderer(this, 12, 17);
        field_78115_e.func_78789_a(-4F, 0F, -4F, 8, 12, 3);
        field_78115_e.func_78793_a(0F, 0F, 3F);
        field_78115_e.func_78787_b(64, 64);
        setRotation(field_78115_e, 0F, 0F, 0F);

        field_178724_i = new ModelRenderer(this, 34, 17);
        field_178724_i.field_78809_i = true;
        field_178724_i.func_78789_a(0F, 0F, -1F, 3, 12, 3);
        field_178724_i.func_78793_a(4F, 0F, 0F);
        field_178724_i.func_78787_b(64, 64);
        setRotation(field_178724_i, 0F, 0F, 0F);

        field_178723_h = new ModelRenderer(this, 34, 17);
        field_178723_h.func_78789_a(-2F, 0F, -1F, 3, 12, 3);
        field_178723_h.func_78793_a(-5F, 0F, 0F);
        field_178723_h.func_78787_b(64, 64);
        setRotation(field_178723_h, 0F, 0F, 0F);

        field_178721_j = new ModelRenderer(this, 0, 17);
        field_178721_j.func_78789_a(-2F, 0F, -2F, 3, 12, 3);
        field_178721_j.func_78793_a(-1F, 12F, 1F);
        field_178721_j.func_78787_b(64, 64);
        setRotation(field_178721_j, 0F, 0F, 0F);

        field_178722_k = new ModelRenderer(this, 0, 17);
        field_178722_k.field_78809_i = true;
        field_178722_k.func_78789_a(-2F, 0F, -2F, 3, 12, 3);
        field_178722_k.func_78793_a(2F, 12F, 1F);
        field_178722_k.func_78787_b(64, 64);
        setRotation(field_178722_k, 0F, 0F, 0F);

        breast = new ModelRenderer(this, 0, 33);
        breast.func_78789_a(-3F, 0F, -2F, 8, 4, 3);
        breast.func_78793_a(-1F, 3F, 1F);
        breast.func_78787_b(64, 64);
        setRotation(breast, -0.5235988F, 0F, 0F);

        hair = new ModelRenderer(this, 46, 17);
        hair.func_78790_a(-4F, 0F, 3F, 8, 7, 1, 0.5F);
        hair.func_78793_a(0F, 0F, 1F);
        hair.func_78787_b(64, 64);
        setRotation(hair, 0F, 0F, 0F);

        dressPart1 = new ModelRenderer(this, 26, 46);
        dressPart1.func_78789_a(-5F, 2F, -4F, 10, 9, 9);
        dressPart1.func_78793_a(0F, 11F, 0F);
        dressPart1.func_78787_b(64, 64);
        setRotation(dressPart1, 0F, 0F, 0F);

        dressPart2 = new ModelRenderer(this, 28, 38);
        dressPart2.func_78789_a(-5F, 1F, -3F, 10, 1, 7);
        dressPart2.func_78793_a(0F, 11F, 0F);
        dressPart2.func_78787_b(64, 64);
        setRotation(dressPart2, 0F, 0F, 0F);

        dressPart3 = new ModelRenderer(this, 32, 32);
        dressPart3.func_78789_a(-4F, 0F, -2F, 8, 1, 5);
        dressPart3.func_78793_a(0F, 11F, 0F);
        dressPart3.func_78787_b(64, 64);
        setRotation(dressPart3, 0F, 0F, 0F);
    }

    private void setRotation(@NotNull final ModelRenderer model, final float x, final float y, final float z)
    {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    @Override
    public void func_78088_a(
                        final Entity entity,
                        final float limbSwing,
                        final float limbSwingAmount,
                        final float ageInTicks,
                        final float netHeadYaw,
                        final float headPitch,
                        final float scaleFactor)
    {
        func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entity);
        field_78116_c.func_78785_a(scaleFactor);
        field_178720_f.func_78785_a(scaleFactor);
        field_78115_e.func_78785_a(scaleFactor);
        field_178724_i.func_78785_a(scaleFactor);
        field_178723_h.func_78785_a(scaleFactor);
        field_178721_j.func_78785_a(scaleFactor);
        field_178722_k.func_78785_a(scaleFactor);
        breast.func_78785_a(scaleFactor);
        hair.func_78785_a(scaleFactor);
        dressPart1.func_78785_a(scaleFactor);
        dressPart2.func_78785_a(scaleFactor);
        dressPart3.func_78785_a(scaleFactor);
    }

    @Override
    public void func_78087_a(
                                   final float limbSwing,
                                   final float limbSwingAmount,
                                   final float ageInTicks,
                                   final float netHeadYaw,
                                   final float headPitch,
                                   final float scaleFactor,
                                   final Entity entityIn)
    {
        field_78116_c.field_78796_g = netHeadYaw / 57.29578F;
        field_78116_c.field_78795_f = headPitch / 57.29578F;
        field_178720_f.field_78796_g = field_78116_c.field_78796_g;
        field_178720_f.field_78795_f = field_78116_c.field_78795_f;
        hair.field_78796_g = field_78116_c.field_78796_g;
        hair.field_78795_f = field_78116_c.field_78795_f;

        field_178723_h.field_78795_f = MathHelper.func_76134_b((float) (limbSwing * 0.6662F + Math.PI)) * 2.0F * limbSwingAmount * 0.5F;
        field_178724_i.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F) * 2.0F * limbSwingAmount * 0.5F;
        field_178723_h.field_78808_h = 0.0F;
        field_178724_i.field_78808_h = 0.0F;

        field_178721_j.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F) * 0.53F * limbSwingAmount;
        field_178722_k.field_78795_f = MathHelper.func_76134_b((float) (limbSwing * 0.6662F + Math.PI)) * 0.53F * limbSwingAmount;
        field_178721_j.field_78796_g = 0.0F;
        field_178722_k.field_78796_g = 0.0F;

        field_178723_h.field_78796_g = 0.0F;
        field_178724_i.field_78796_g = 0.0F;

        // free stand rotation
        field_178723_h.field_78808_h += MathHelper.func_76134_b(ageInTicks * 0.09F) * 0.05F + 0.05F;
        field_178724_i.field_78808_h -= MathHelper.func_76134_b(ageInTicks * 0.09F) * 0.05F + 0.05F;
        field_178723_h.field_78795_f += MathHelper.func_76126_a(ageInTicks * 0.067F) * 0.05F;
        field_178724_i.field_78795_f -= MathHelper.func_76126_a(ageInTicks * 0.067F) * 0.05F;

        if (field_78095_p > -9990F)
        {
            float f6 = field_78095_p;
            field_78115_e.field_78796_g = MathHelper.func_76126_a((float) (MathHelper.func_76129_c(f6) * Math.PI * 2.0F)) * 0.2F;
            breast.field_78796_g = MathHelper.func_76126_a((float) (MathHelper.func_76129_c(f6) * Math.PI * 2.0F)) * 0.2F;
            field_178723_h.field_78798_e = MathHelper.func_76126_a(field_78115_e.field_78796_g) * 5F;
            field_178723_h.field_78800_c = -MathHelper.func_76134_b(field_78115_e.field_78796_g) * 5F;
            field_178724_i.field_78798_e = -MathHelper.func_76126_a(field_78115_e.field_78796_g) * 5F;
            field_178723_h.field_78796_g += field_78115_e.field_78796_g;
            field_178724_i.field_78796_g += field_78115_e.field_78796_g;
            //noinspection SuspiciousNameCombination
            field_178724_i.field_78795_f += field_78115_e.field_78796_g;//TODO If model looks funny try changing to rotateAngleX
            f6 = 1.0F - field_78095_p;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0F - f6;
            final float f7 = MathHelper.func_76126_a((float) (f6 * Math.PI));
            final float f8 = MathHelper.func_76126_a((float) (field_78095_p * Math.PI)) * -(field_78116_c.field_78795_f - 0.7F) * 0.75F;
            field_178723_h.field_78795_f -= f7 * 1.2D + f8;
            field_178723_h.field_78796_g += field_78115_e.field_78796_g * 2.0F;
            field_178723_h.field_78808_h = MathHelper.func_76126_a((float) (field_78095_p * Math.PI)) * -0.4F;
        }
    }
}
