package com.minecolonies.coremod.client.model;

import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class ModelEntityCitizenFemaleNoble extends ModelBiped
{
    ModelRenderer breast;
    ModelRenderer hair;
    ModelRenderer dressPart1;
    ModelRenderer dressPart2;
    ModelRenderer dressPart3;
    ModelRenderer dressPart4;
    ModelRenderer dressPart5;
    ModelRenderer hat1;
    ModelRenderer hat2;
    ModelRenderer bag;
    ModelRenderer bagHand1;
    ModelRenderer bagHand2;

    public ModelEntityCitizenFemaleNoble()
    {
        field_78090_t = 128;
        field_78089_u = 64;

        field_78116_c = new ModelRenderer(this, 0, 0);
        field_78116_c.func_78789_a(-4F, -8F, -4F, 8, 8, 8);
        field_78116_c.func_78793_a(0F, 0F, 1F);
        field_78116_c.func_78787_b(128, 64);
        setRotation(field_78116_c, 0F, 0F, 0F);

        field_178720_f = new ModelRenderer(this, 32, 0);
        field_178720_f.func_78790_a(-4F, -8F, -4F, 8, 8, 8, 0.5F);
        field_178720_f.func_78793_a(0F, 0F, 1F);
        field_178720_f.func_78787_b(128, 64);
        setRotation(field_178720_f, 0F, 0F, 0F);

        field_78115_e = new ModelRenderer(this, 12, 17);
        field_78115_e.func_78789_a(-4F, 0F, -4F, 8, 12, 3);
        field_78115_e.func_78793_a(0F, 0F, 3F);
        field_78115_e.func_78787_b(128, 64);
        setRotation(field_78115_e, 0F, 0F, 0F);

        field_178724_i = new ModelRenderer(this, 34, 17);
        field_178724_i.field_78809_i = true;
        field_178724_i.func_78789_a(0F, 0F, -1F, 3, 12, 3);
        field_178724_i.func_78793_a(4F, 0F, 0F);
        field_178724_i.func_78787_b(128, 64);
        setRotation(field_178724_i, 0F, 0F, -0.1396263F);

        field_178723_h = new ModelRenderer(this, 34, 17);
        field_178723_h.func_78789_a(-2F, 0F, -1F, 3, 12, 3);
        field_178723_h.func_78793_a(-5F, 0F, 0F);
        field_178723_h.func_78787_b(128, 64);
        setRotation(field_178723_h, 0F, 0F, 0F);

        field_178721_j = new ModelRenderer(this, 0, 17);
        field_178721_j.func_78789_a(-2F, 0F, -2F, 3, 12, 3);
        field_178721_j.func_78793_a(-1F, 12F, 1F);
        field_178721_j.func_78787_b(128, 64);
        setRotation(field_178721_j, 0F, 0F, 0F);

        field_178722_k = new ModelRenderer(this, 0, 17);
        field_178722_k.field_78809_i = true;
        field_178722_k.func_78789_a(-2F, 0F, -2F, 3, 12, 3);
        field_178722_k.func_78793_a(2F, 12F, 1F);
        field_178722_k.func_78787_b(128, 64);
        setRotation(field_178722_k, 0F, 0F, 0F);

        breast = new ModelRenderer(this, 0, 33);
        breast.func_78789_a(-3F, 0F, -2F, 8, 4, 3);
        breast.func_78793_a(-1F, 3F, 1F);
        breast.func_78787_b(128, 64);
        setRotation(breast, -0.5235988F, 0F, 0F);

        hair = new ModelRenderer(this, 46, 17);
        hair.func_78790_a(-4F, 0F, 3F, 8, 7, 1, 0.5F);
        hair.func_78793_a(0F, 0F, 1F);
        hair.func_78787_b(128, 64);
        setRotation(hair, 0F, 0F, 0F);

        dressPart1 = new ModelRenderer(this, 65, 48);
        dressPart1.func_78789_a(-8F, 9F, -6F, 16, 3, 13);
        dressPart1.func_78793_a(0F, 11F, 0F);
        dressPart1.func_78787_b(128, 64);
        setRotation(dressPart1, 0F, 0F, 0F);

        dressPart2 = new ModelRenderer(this, 65, 34);
        dressPart2.func_78789_a(-7F, 6F, -5F, 14, 3, 11);
        dressPart2.func_78793_a(0F, 11F, 0F);
        dressPart2.func_78787_b(128, 64);
        setRotation(dressPart2, 0F, 0F, 0F);

        dressPart3 = new ModelRenderer(this, 65, 23);
        dressPart3.func_78789_a(-6F, 4F, -4F, 12, 2, 9);
        dressPart3.func_78793_a(0F, 11F, 0F);
        dressPart3.func_78787_b(128, 64);
        setRotation(dressPart3, 0F, 0F, 0F);

        dressPart4 = new ModelRenderer(this, 65, 14);
        dressPart4.func_78789_a(-5F, 2F, -3F, 10, 2, 7);
        dressPart4.func_78793_a(0F, 11F, 0F);
        dressPart4.func_78787_b(128, 64);
        setRotation(dressPart4, 0F, 0F, 0F);

        dressPart5 = new ModelRenderer(this, 65, 7);
        dressPart5.func_78789_a(-4F, 0F, -2F, 8, 2, 5);
        dressPart5.func_78793_a(0F, 11F, 0F);
        dressPart5.func_78787_b(128, 64);
        setRotation(dressPart5, 0F, 0F, 0F);

        hat1 = new ModelRenderer(this, 0, 48);
        hat1.func_78790_a(-5F, -8F, -5F, 10, 2, 10, 0.1F);
        hat1.func_78793_a(0F, 0F, 1F);
        hat1.func_78787_b(128, 64);
        setRotation(hat1, 0F, 0F, 0F);

        hat2 = new ModelRenderer(this, 0, 40);
        hat2.func_78790_a(-3F, -10F, -3F, 6, 2, 6, 0.3F);
        hat2.func_78793_a(0F, 0F, 1F);
        hat2.func_78787_b(128, 64);
        setRotation(hat2, 0F, 0F, 0F);

        bag = new ModelRenderer(this, 24, 32);
        bag.func_78789_a(0F, 6F, -3F, 1, 4, 7);
        bag.func_78793_a(4F, 0F, 0F);
        bag.func_78787_b(128, 64);
        setRotation(bag, 0F, 0F, 0F);

        bagHand1 = new ModelRenderer(this, 40, 32);
        bagHand1.func_78789_a(0F, 0F, 0F, 1, 7, 0);
        bagHand1.func_78793_a(4F, 0F, 0F);
        bagHand1.func_78787_b(128, 64);
        setRotation(bagHand1, -0.4014257F, 0F, 0F);

        bagHand2 = new ModelRenderer(this, 40, 32);
        bagHand2.func_78789_a(0F, 0F, 1F, 1, 7, 0);
        bagHand2.func_78793_a(4F, 0F, 0F);
        bagHand2.func_78787_b(128, 64);
        setRotation(bagHand2, 0.4014257F, 0F, 0F);
    }

    private void setRotation(@NotNull final ModelRenderer model, final float x, final float y, final float z)
    {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    @Override
    public void func_78088_a(
                        final Entity entity,
                        final float limbSwing,
                        final float limbSwingAmount,
                        final float ageInTicks,
                        final float netHeadYaw,
                        final float headPitch,
                        final float scaleFactor)
    {
        func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entity);
        field_78116_c.func_78785_a(scaleFactor);
        field_178720_f.func_78785_a(scaleFactor);
        field_78115_e.func_78785_a(scaleFactor);
        field_178724_i.func_78785_a(scaleFactor);
        field_178723_h.func_78785_a(scaleFactor);
        field_178721_j.func_78785_a(scaleFactor);
        field_178722_k.func_78785_a(scaleFactor);
        breast.func_78785_a(scaleFactor);
        hair.func_78785_a(scaleFactor);
        dressPart1.func_78785_a(scaleFactor);
        dressPart2.func_78785_a(scaleFactor);
        dressPart3.func_78785_a(scaleFactor);
        dressPart4.func_78785_a(scaleFactor);
        dressPart5.func_78785_a(scaleFactor);
        hat1.func_78785_a(scaleFactor);
        hat2.func_78785_a(scaleFactor);
        bag.func_78785_a(scaleFactor);
        bagHand1.func_78785_a(scaleFactor);
        bagHand2.func_78785_a(scaleFactor);
    }

    @Override
    public void func_78087_a(
                                   final float limbSwing,
                                   final float limbSwingAmount,
                                   final float ageInTicks,
                                   final float netHeadYaw,
                                   final float headPitch,
                                   final float scaleFactor,
                                   final Entity entityIn)
    {
        field_78116_c.field_78796_g = netHeadYaw / 57.29578F;
        field_78116_c.field_78795_f = headPitch / 57.29578F;
        field_178720_f.field_78796_g = field_78116_c.field_78796_g;
        field_178720_f.field_78795_f = field_78116_c.field_78795_f;
        hair.field_78796_g = field_78116_c.field_78796_g;
        hair.field_78795_f = field_78116_c.field_78795_f;
        hat1.field_78796_g = field_78116_c.field_78796_g;
        hat1.field_78795_f = field_78116_c.field_78795_f;
        hat2.field_78796_g = field_78116_c.field_78796_g;
        hat2.field_78795_f = field_78116_c.field_78795_f;

        field_178723_h.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F + 3.141593F) * 2.0F * limbSwingAmount * 0.5F;
        field_178724_i.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F) * 2.0F * limbSwingAmount * 0.5F;
        field_178721_j.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F) * 0.73F * limbSwingAmount;
        field_178722_k.field_78795_f = MathHelper.func_76134_b(limbSwing * 0.6662F + 3.141593F) * 0.73F * limbSwingAmount;

        field_178723_h.field_78795_f += MathHelper.func_76126_a(ageInTicks * 0.067F) * 0.05F;
        field_178724_i.field_78795_f -= MathHelper.func_76126_a(ageInTicks * 0.067F) * 0.05F;
    }
}
