package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.coremod.util.SoundUtils;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;

/**
 * Used for automatic gate open/close.
 */
public class EntityAIOpenFenceGate extends EntityAIGateInteract
{
    /**
     * Close door after ... ticks.
     */
    private static final int TIME_TO_CLOSE_DOOR = 20;
    /**
     * Checks if the gate should be closed.
     */
    private final boolean closeDoor;
    /**
     * Ticks until the gate should be closed.
     */
    private       int     closeDoorTemporisation;

    /**
     * Constructor called to register the AI class with an entity.
     *
     * @param entityLivingIn the registering entity.
     * @param shouldClose    should the entity close the gate.
     */
    public EntityAIOpenFenceGate(@NotNull final EntityLiving entityLivingIn, final boolean shouldClose)
    {
        super(entityLivingIn);
        this.theEntity = entityLivingIn;
        this.closeDoor = shouldClose;
    }

    /**
     * Should the AI continue to execute.
     *
     * @return true or false.
     */
    @Override
    public boolean func_75253_b()
    {
        return this.closeDoor && this.closeDoorTemporisation > 0 && super.func_75253_b();
    }

    /**
     * Start the execution.
     * Initiate time frame until closing.
     */
    @Override
    public void func_75249_e()
    {
        this.closeDoorTemporisation = TIME_TO_CLOSE_DOOR;
        toggleDoor(true);
    }

    /**
     * Toggles the door(Opens or closes).
     *
     * @param open if open or close.
     */
    private void toggleDoor(final boolean open)
    {
        final IBlockState iblockstate = this.theEntity.field_70170_p.func_180495_p(this.gatePosition);
        //If the block is a gate block and the fence gate state does not respond to the input open toggle it.
        if (iblockstate.func_177230_c() == this.gateBlock && (iblockstate.func_177229_b(BlockFenceGate.field_176466_a)) != open)
        {
            this.theEntity.field_70170_p.func_180501_a(this.gatePosition, iblockstate.func_177226_a(BlockFenceGate.field_176466_a, open), 2);
            final SoundEvent openCloseSound = open ? SoundEvents.field_187613_bi : SoundEvents.field_187610_bh;
            SoundUtils.playSoundAtCitizen(this.theEntity.field_70170_p, this.gatePosition, openCloseSound);
        }
    }

    /**
     * Updates the task.
     * Decrease the time the door is open already.
     * Door has to stay open enough to let the worker go through it.
     */
    @Override
    public void func_75246_d()
    {
        --this.closeDoorTemporisation;
        super.func_75246_d();
    }

    /**
     * Reset the action.
     * Close the door.
     */
    @Override
    public void func_75251_c()
    {
        if (this.closeDoor)
        {
            toggleDoor(false);
        }
    }
}


